/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.time.DateFormatUtils;

public class DateUtils
extends org.apache.commons.lang.time.DateUtils {
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    private static final String YYYY_MM_DD = "yyyy-MM-dd";
    private static String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM"};

    public static String getDate() {
        return DateUtils.getDate(YYYY_MM_DD);
    }

    public static String getDate(String pattern) {
        return DateFormatUtils.format((Date)new Date(), (String)pattern);
    }

    public static String formatDate(Date date, Object ... pattern) {
        if (date == null) {
            return null;
        }
        String formatDate = null;
        formatDate = pattern != null && pattern.length > 0 ? DateFormatUtils.format((Date)date, (String)pattern[0].toString()) : DateFormatUtils.format((Date)date, (String)YYYY_MM_DD);
        return formatDate;
    }

    public static String formatDateTime(Date date) {
        return DateUtils.formatDate(date, YYYY_MM_DD_HH_MM_SS);
    }

    public static String getTime(Date date) {
        return DateUtils.formatDate(date, "HH:mm:ss");
    }

    public static String getTime() {
        return DateUtils.formatDate(new Date(), "HH:mm:ss");
    }

    public static String getDateTime() {
        return DateUtils.formatDate(new Date(), YYYY_MM_DD_HH_MM_SS);
    }

    public static String getYear() {
        return DateUtils.formatDate(new Date(), "yyyy");
    }

    public static String getMonth() {
        return DateUtils.formatDate(new Date(), "MM");
    }

    public static String getDay() {
        return DateUtils.formatDate(new Date(), "dd");
    }

    public static String getWeek() {
        return DateUtils.formatDate(new Date(), "E");
    }

    public static Date parseDate(Object str) {
        if (str == null) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)str.toString(), (String[])parsePatterns);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date parseDateTime(String dateTime, String format) {
        Date returnDate = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            returnDate = dateFormat.parse(dateTime);
        }
        catch (ParseException e) {
            return null;
        }
        return returnDate;
    }

    public static long pastDays(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / 86400000L;
    }

    public static long pastHour(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / 3600000L;
    }

    public static long pastMinutes(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / 60000L;
    }

    public static String formatDateTime(long timeMillis) {
        long day = timeMillis / 86400000L;
        long hour = timeMillis / 3600000L - day * 24L;
        long min = timeMillis / 60000L - day * 24L * 60L - hour * 60L;
        long s = timeMillis / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        long sss = timeMillis - day * 24L * 60L * 60L * 1000L - hour * 60L * 60L * 1000L - min * 60L * 1000L - s * 1000L;
        return (day > 0L ? day + "," : "") + hour + ":" + min + ":" + s + "." + sss;
    }

    public static double getDistanceOfTwoDate(Date before, Date after) {
        long beforeTime = before.getTime();
        long afterTime = after.getTime();
        return (afterTime - beforeTime) / 86400000L;
    }

    public static String getFirstDayOfMonth() {
        SimpleDateFormat format = new SimpleDateFormat(YYYY_MM_DD);
        Calendar c = Calendar.getInstance();
        c.add(2, 0);
        c.set(5, 1);
        String first = format.format(c.getTime());
        return first;
    }

    public static LocalDateTime getLocalDate() {
        return LocalDateTime.now();
    }

    public static LocalDateTime getLocalDateByOld(Date current) {
        Instant instant = current.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        return LocalDateTime.ofInstant(instant, zone);
    }

    public static Date plusSecondsWithDate(Date current, int seconds) {
        LocalDateTime local = DateUtils.getLocalDateByOld(current);
        local = local.plusSeconds(seconds);
        return DateUtils.convertLocalDateTime2Date(local);
    }

    public static Date convertLocalDateTime2Date(LocalDateTime localDateTime) {
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return Date.from(instant);
    }

    public static void main(String[] args) throws ParseException {
        Date currentDate = new Date();
        System.out.println(DateUtils.formatDateTime(currentDate));
        currentDate = DateUtils.plusSecondsWithDate(currentDate, 10);
        System.out.println(DateUtils.formatDateTime(currentDate));
    }
}

