/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class RequestUtils {
    private static final Log logger = LogFactory.getLog(RequestUtils.class);
    private static final String UPPER_UTF_8 = "UTF-8";

    public static String getRequestBody(HttpServletRequest request) {
        StringBuilder bodyStr = new StringBuilder();
        try (BufferedInputStream bis = new BufferedInputStream((InputStream)request.getInputStream());){
            int n;
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((n = bis.read(buffer)) != -1) {
                bos.write(buffer, 0, n);
            }
            byte[] input = bos.toByteArray();
            bodyStr.append(new String(input, UPPER_UTF_8));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            bodyStr.append(e.getMessage());
        }
        return bodyStr.toString();
    }

    public static String getParamerter(HttpServletRequest request, String parameter) {
        String returnValue = null;
        String parameterValue = request.getHeader(parameter);
        if (StringUtils.isEmpty((String)parameterValue)) {
            parameterValue = request.getParameter(parameter);
        }
        if (StringUtils.isNotEmpty((String)parameterValue)) {
            returnValue = parameterValue;
        }
        return returnValue;
    }
}

