/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.msgjet;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.msgjet.MsgReceive;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class MsgReceiveListener {
    private static ThreadPool pool = ThreadPools.newFixedThreadPool("WebsocketSendMsgToBrowser", Integer.getInteger("websocket.sendthread", 2));
    private static Log log = LogFactory.getLog(MsgReceiveListener.class);
    private static Map<String, MsgReceive> listeners = new ConcurrentHashMap<String, MsgReceive>();

    public void recive(String o) {
        try {
            pool.execute(() -> {
                try {
                    listeners.forEach((k, v) -> v.onMessage(o));
                }
                catch (Error | Exception e) {
                    log.error("websocket sendMessage to Browser error", e);
                }
            });
        }
        catch (Error | Exception e) {
            log.error("websocket sendMessage to pool error", e);
        }
    }

    public static void register(MsgReceive receiver) {
        listeners.put(receiver.getClass().getName(), receiver);
    }

    public static void unregister(String receiverClassName) {
        listeners.remove(receiverClassName);
    }
}

