/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.msgjet.channel;

import kd.bos.instance.Instance;
import kd.bos.msgjet.channel.Channel;
import kd.bos.msgjet.channel.fake.FakeChannelFactory;
import kd.bos.msgjet.channel.jms.JMSChannel;
import kd.bos.msgjet.channel.mq.MQAdaptChannel;
import kd.bos.msgjet.channel.rabbitmq.RabbitmqChannel;
import kd.bos.msgjet.channel.redis.RedisChannel;

public class ChannelFactory {
    public static Channel getChannel() {
        String channelType = System.getProperty("msgjet.channel.type", "redis");
        if (Instance.isLightWeightDeploy()) {
            return FakeChannelFactory.getFakeChannel();
        }
        if ("redis".equals(channelType)) {
            return RedisChannel.getInstance();
        }
        if ("rabbitmq".equals(channelType)) {
            return RabbitmqChannel.getInstance();
        }
        if ("jms".equals(channelType)) {
            return JMSChannel.getInstance();
        }
        if ("mq".equals(channelType)) {
            return MQAdaptChannel.getInstance();
        }
        throw new Error("not support msgjet channel type");
    }
}

