/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.msgjet.channel;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.msgjet.channel.ChannelFactory;

public class SubPubHeartbeat {
    private static final Log log = LogFactory.getLog(SubPubHeartbeat.class);
    public static final String HEARTBEAT_MSG = "SUBPUB_HEARTBEAT_MSG";
    public static final String HEARTBEAT_ENABLE = "websocket.subpub.heartbeat.enable";
    private static final String HEARTBEAT_PERIOD = "websocket.subpub.heartbeat.period";
    private static ScheduledExecutorService ses = Executors.newScheduledThreadPool(1);

    public static void start() {
        if (SubPubHeartbeat.heartbeatEnable()) {
            log.info("Subscribe/Publish in Websocket start.");
            ses.scheduleAtFixedRate(() -> ChannelFactory.getChannel().send(HEARTBEAT_MSG), 1L, SubPubHeartbeat.getPeriod(), TimeUnit.MINUTES);
        }
    }

    public static boolean heartbeatEnable() {
        return Boolean.parseBoolean(System.getProperty(HEARTBEAT_ENABLE, "false"));
    }

    private static int getPeriod() {
        return Integer.getInteger(HEARTBEAT_PERIOD, 2);
    }

    public static boolean isHeartbeat(String msg) {
        return SubPubHeartbeat.heartbeatEnable() && HEARTBEAT_MSG.equals(msg);
    }
}

