/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.msgjet.channel.mq;

import java.lang.reflect.Method;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.msgjet.channel.Channel;
import kd.bos.msgjet.channel.SubPubHeartbeat;
import kd.bos.util.StringUtils;

public class MQAdaptChannel
implements Channel {
    private static final Log log = LogFactory.getLog(MQAdaptChannel.class);
    public static final String CONSUMER_CLASS = MQAdaptChannel.class.getName();
    public static final String CONSUMER_METHOD = "consumer";
    private static Channel instance = new MQAdaptChannel();

    public static Channel getInstance() {
        return instance;
    }

    @Override
    public void send(String msg) {
        if (StringUtils.isEmpty((String)msg)) {
            return;
        }
        try {
            Class<?> clz = Class.forName("kd.bos.mq.WebsocketUtils");
            Method m = clz.getMethod("broadcastMessage", String.class, String.class, String.class);
            m.invoke(null, CONSUMER_CLASS, CONSUMER_METHOD, msg);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.jmsmqException, "JMS: get session error", (Throwable)e);
        }
    }

    @Override
    public void registerCustomer() {
        log.info("MQ Adapt Channel: No registered consumer required.");
    }

    public static void consumer(String message) {
        if (SubPubHeartbeat.isHeartbeat(message)) {
            return;
        }
        reciver.recive(message);
    }
}

