/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.msgjet.channel.redis;

import java.lang.reflect.Field;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.msgjet.channel.Channel;
import kd.bos.msgjet.channel.redis.RedisUtil;
import kd.bos.msgjet.channel.redis.SubPub;
import kd.bos.msgjet.channel.redis.Subscriber;
import redis.clients.jedis.Client;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class RedisChannel
implements Channel {
    private static RedisChannel instance = new RedisChannel();
    private static Log log = LogFactory.getLog(RedisChannel.class);
    private final String channel = Instance.getClusterName().trim() + "_msgchannel";

    public static Channel getInstance() {
        return instance;
    }

    private SubPub getJedis() {
        return RedisUtil.getClient();
    }

    @Override
    public void send(String o) {
        block14: {
            try (SubPub jedis = this.getJedis();){
                jedis.publish(this.channel, o);
            }
            catch (KDException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof JedisConnectionException)) break block14;
                log.error("redis connection error", (Throwable)e);
            }
        }
    }

    @Override
    public void registerCustomer() {
        log.info("registerConsumer begin register redis customer");
        Subscriber subscriber = new Subscriber();
        subscriber.setReciver(reciver);
        try (SubPub jedis = this.getJedis();){
            log.info("registerConsumer success get redis subpub");
            jedis.subscribe(subscriber, this.channel);
        }
        catch (Error | Exception e) {
            log.error("registerConsumer subscribe error", e);
            throw new KDException(BosErrorCode.bOS, new Object[]{e});
        }
        finally {
            this.unsubscribe(subscriber);
            this.disconnectClient(subscriber);
        }
    }

    private void unsubscribe(Subscriber subscriber) {
        try {
            subscriber.unsubscribe();
        }
        catch (Error | Exception e) {
            log.error("registerConsumer unsubscribe error", e);
            throw new KDException(BosErrorCode.bOS, new Object[]{e});
        }
    }

    private void disconnectClient(Subscriber subscriber) {
        try {
            Field field = ((Object)((Object)subscriber)).getClass().getSuperclass().getDeclaredField("client");
            field.setAccessible(true);
            Client client = (Client)field.get((Object)subscriber);
            client.disconnect();
        }
        catch (Error | Exception e) {
            log.error("registerConsumer disconnect redis error", e);
            throw new KDException(BosErrorCode.bOS, new Object[]{e});
        }
    }
}

