/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.msgjet.channel.redis;

import kd.bos.cache.CacheConfigKeys;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.msgjet.channel.redis.JedisClusterSubPub;
import kd.bos.msgjet.channel.redis.JedisSubPub;
import kd.bos.msgjet.channel.redis.SubPub;
import kd.bos.redis.RedisFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;

public class RedisUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static SubPub getClient() {
        try (TraceSpan span = Tracer.create((String)"RedisChannel", (String)"getJedis");){
            String configKey;
            String url = null;
            if (url == null && (configKey = CacheConfigKeys.getSessionlessConfigKey((String)"msgjet")) != null) {
                url = System.getProperty(configKey);
            }
            if (url == null) {
                configKey = CacheConfigKeys.getSessionlessConfigKey(null);
                url = System.getProperty(configKey);
            }
            if (url.toLowerCase().startsWith("redis:") || url.toLowerCase().startsWith("sentinel:")) {
                JedisSubPub jedisSubPub = new JedisSubPub((Jedis)RedisFactory.$getJedisClientOriginal((String)url));
                return jedisSubPub;
            }
            if (url.toLowerCase().startsWith("cluster:")) {
                JedisClusterSubPub jedisClusterSubPub = new JedisClusterSubPub((JedisCluster)RedisFactory.$getJedisClientOriginal((String)url));
                return jedisClusterSubPub;
            }
            url = RedisUtil.getParseUrl(url);
            JedisSubPub jedisSubPub = new JedisSubPub((Jedis)RedisFactory.$getJedisClientOriginal((String)url));
            return jedisSubPub;
        }
        catch (Exception t) {
            throw new KDException((Throwable)t, BosErrorCode.redisConnection, new Object[]{t});
        }
    }

    private static String getParseUrl(String url) {
        String[] parts = url.split("/");
        String password = null;
        if (parts.length == 2) {
            password = parts[1];
        }
        url = parts[0];
        String[] redisAddr = url.split(";")[0].split(":");
        String ip = null;
        String port = null;
        if (redisAddr.length == 3) {
            ip = redisAddr[1];
            port = redisAddr[2];
        } else if (redisAddr.length == 2) {
            ip = redisAddr[0];
            port = redisAddr[1];
        }
        url = "redis:" + ip + ":" + port;
        if (password != null) {
            url = url + "/" + password;
        }
        return url;
    }
}

