/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.msgjet.websocket.jetty.demo.client;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;

@WebSocket(maxTextMessageSize=65536)
public class SimpleEchoSocket {
    private static final Log log = LogFactory.getLog(SimpleEchoSocket.class);
    private final CountDownLatch closeLatch = new CountDownLatch(1);

    public boolean awaitClose(int duration, TimeUnit unit) throws InterruptedException {
        return this.closeLatch.await(duration, unit);
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        this.closeLatch.countDown();
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        try {
            Future fut = session.getRemote().sendStringByFuture("11111Hello");
            fut.get(2L, TimeUnit.SECONDS);
            fut = session.getRemote().sendStringByFuture("222222Thanks for the conversation.");
            fut.get(2L, TimeUnit.SECONDS);
            session.close(1000, "I'm done");
        }
        catch (Exception t) {
            log.warn((Throwable)t);
        }
    }

    @OnWebSocketMessage
    public void onMessage(String msg) {
    }
}

