/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newfeature;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.login.utils.DateUtils;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.tenant.TenantInfo;
import kd.bos.util.StringUtils;
import org.junit.Assert;

public class TenantService {
    public static final int LE = -1;
    public static final int GE = 1;
    public static final int EQ = 0;

    public static boolean isNewTenantByFeatureOFCosmic(String versionDateString, String versionNumber) {
        return TenantService.isNewTenantByFeature(versionDateString, versionNumber, "cosmic_bos");
    }

    public static boolean isNewTenantByFeature(String versionDateString, String versionNumber, String productNumber) {
        boolean isNewTenant = false;
        Date versionDate = null;
        if (StringUtils.isNotEmpty((String)versionDateString)) {
            versionDate = DateUtils.parseDate(versionDateString);
        }
        if (versionDate != null && StringUtils.isNotEmpty((String)versionNumber)) {
            Boolean isok = SystemPropertyUtils.getBooleanExt(RequestContext.get().getTenantId(), versionNumber + versionDateString, null);
            if (isok != null) {
                return isok;
            }
            TenantInfo tenantInfo = AccountUtils.getTenantByid((String)RequestContext.get().getTenantId());
            if (tenantInfo != null && tenantInfo.getCreateTime() != null) {
                boolean dateOk = false;
                if (tenantInfo.getCreateTime() >= versionDate.getTime()) {
                    dateOk = true;
                }
                String currentVersion = "";
                if (tenantInfo.getCreateVersion() != null) {
                    currentVersion = (String)tenantInfo.getCreateVersion().get(productNumber);
                }
                if (dateOk && StringUtils.isNotEmpty((String)currentVersion)) {
                    List<Integer> newFAarry = TenantService.getVersionArray(versionNumber);
                    List<Integer> cosmicArray = TenantService.getVersionArray(currentVersion);
                    if (cosmicArray != null && cosmicArray.size() > 0 && TenantService.compareVersion(newFAarry, cosmicArray) < 0) {
                        isNewTenant = true;
                    }
                }
            }
        }
        return isNewTenant;
    }

    public static int compareVersion(List<Integer> firstList, List<Integer> secondList) {
        int result = -1;
        if (firstList != null && secondList != null) {
            int length = firstList.size() > secondList.size() ? secondList.size() : firstList.size();
            for (int i = 0; i < length; ++i) {
                if (firstList.get(i) > secondList.get(i)) {
                    result = 1;
                    break;
                }
                if (!firstList.get(i).equals(secondList.get(i))) {
                    result = -1;
                    break;
                }
                result = 0;
            }
            if (0 == result && firstList.size() != secondList.size()) {
                result = firstList.size() > secondList.size() ? 1 : -1;
            }
        }
        return result;
    }

    public static List<Integer> getVersionArray(String versionNumber) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (StringUtils.isNotEmpty((String)versionNumber)) {
            StringBuilder temp = null;
            for (int i = 0; i < versionNumber.length(); ++i) {
                String currentS;
                if (temp == null) {
                    temp = new StringBuilder();
                }
                if (StringUtils.isNumericString((String)(currentS = versionNumber.substring(i, i + 1)))) {
                    temp.append(currentS);
                    continue;
                }
                if (StringUtils.isNumericString((String)temp.toString())) {
                    list.add(Integer.parseInt(temp.toString()));
                    temp = null;
                    continue;
                }
                temp = null;
            }
            if (temp != null && StringUtils.isNumericString((String)temp.toString())) {
                list.add(Integer.parseInt(temp.toString()));
            }
        }
        return list;
    }

    public static void main(String[] args) {
        List<Integer> list = TenantService.getVersionArray("5.3.23.1.2,1");
        List<Integer> list2 = TenantService.getVersionArray("5.3.23.1.2,1");
        System.out.println(TenantService.compareVersion(list, list2));
        Assert.assertTrue((list != null && list.size() == 6 ? 1 : 0) != 0);
    }
}

