/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.resource.balancer;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.exception.KDException;
import kd.bos.resource.balancer.ResourceBalanceErrorCode;
import kd.bos.resource.balancer.allocator.threadpool.KDThreadPoolEnum;
import kd.bos.resource.balancer.allocator.threadpool.KDThreadPoolExecutor;
import kd.bos.resource.balancer.quota.ResourceConfigManage;

public class KDThreadPoolFactory {
    private static Map<String, KDThreadPoolExecutor> poolMap = new ConcurrentHashMap<String, KDThreadPoolExecutor>();

    public static KDThreadPoolExecutor getOrCreate(KDThreadPoolEnum poolEnum, int coreThread, int maxThread) {
        return KDThreadPoolFactory.getOrCreate(poolEnum.getResourceName(), coreThread, maxThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KDThreadPoolExecutor getOrCreate(String poolName, int coreThread, int maxThread) {
        KDThreadPoolExecutor pool = poolMap.get(poolName);
        if (pool == null) {
            Map<String, KDThreadPoolExecutor> map = poolMap;
            synchronized (map) {
                pool = poolMap.get(poolName);
                if (pool == null) {
                    pool = KDThreadPoolFactory.create(poolName, coreThread, maxThread);
                }
            }
        }
        return pool;
    }

    public static KDThreadPoolExecutor create(KDThreadPoolEnum poolEnum, int coreThread, int maxThread) {
        return KDThreadPoolFactory.create(poolEnum.getResourceName(), coreThread, maxThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KDThreadPoolExecutor create(String poolName, int coreThread, int maxThread) {
        if (poolName == null) {
            throw new KDException(ResourceBalanceErrorCode.poolNameException, new Object[]{" pool name can`t be null"});
        }
        List<String> registerPoolNames = ResourceConfigManage.getAllResourceList();
        if (!registerPoolNames.contains(poolName)) {
            throw new KDException(ResourceBalanceErrorCode.poolNameException, new Object[]{" Invalid pool name, the name is not registered in the configuration"});
        }
        if (poolMap.containsKey(poolName)) {
            throw new KDException(ResourceBalanceErrorCode.poolNameException, new Object[]{"The pool name already exists! Please do not create it again."});
        }
        Map<String, KDThreadPoolExecutor> map = poolMap;
        synchronized (map) {
            KDThreadPoolExecutor pool = new KDThreadPoolExecutor(poolName, coreThread, maxThread);
            poolMap.put(poolName, pool);
            return pool;
        }
    }
}

