/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.resource.balancer.allocator.loadstrategy;

import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import kd.bos.resource.balancer.allocator.loadstrategy.LoadStrategy;
import kd.bos.resource.balancer.dimension.DimensionValue;
import kd.bos.resource.balancer.dimension.Isolator;

public class StdLoadStrategy
implements LoadStrategy {
    @Override
    public <E> E choose(Isolator isolator, Map<String, LinkedBlockingQueue<E>> queueContainer) {
        LinkedBlockingQueue<E> choosed = null;
        String choosedAccount = null;
        int choosedPriorityLevel = 0;
        long minUtilizationRateLevel = Integer.MAX_VALUE;
        for (Map.Entry<String, LinkedBlockingQueue<E>> entry : queueContainer.entrySet()) {
            int actPriorityLevel;
            LinkedBlockingQueue<E> actQueue = entry.getValue();
            String actKey = entry.getKey();
            DimensionValue dv = isolator.getDimensionIsolateValue(entry.getKey());
            if (actQueue.isEmpty() || !isolator.hasQuota(dv)) continue;
            long using = isolator.inUsingForCurIsolation(dv);
            long quota = isolator.getQuota(dv);
            if (quota <= 0L) continue;
            long utilizationRateLevel = using * 100L / quota / 10L;
            if (minUtilizationRateLevel > utilizationRateLevel) {
                minUtilizationRateLevel = utilizationRateLevel;
                choosed = actQueue;
                choosedAccount = actKey;
                choosedPriorityLevel = isolator.getPriorityLevel(dv);
                continue;
            }
            if (minUtilizationRateLevel != utilizationRateLevel || (actPriorityLevel = isolator.getPriorityLevel(dv)) <= choosedPriorityLevel) continue;
            choosed = actQueue;
            choosedAccount = actKey;
            choosedPriorityLevel = isolator.getPriorityLevel(dv);
        }
        if (choosed != null) {
            return choosed.poll();
        }
        return null;
    }
}

