/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.resource.balancer.allocator.threadpool;

import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextThreadBinder;
import kd.bos.thread.SetThreadName;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.util.TraceIdUtil;

public class ContextRunnable
implements Runnable {
    private final Runnable r;
    private Object threadLocal;
    private RequestContext rc;
    private final OperationContext oc;
    private boolean isManaged;

    public ContextRunnable(Runnable r, RequestContext rc, OperationContext oc) {
        if (rc != null) {
            this.rc = RequestContext.copy(rc);
        }
        this.r = r;
        this.oc = oc;
    }

    public ContextRunnable bind(Object threadLocal) {
        this.threadLocal = threadLocal;
        return this;
    }

    public ContextRunnable setManaged(boolean managed) {
        this.isManaged = managed;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.isManaged) {
            ThreadLifeCycleManager.start();
        }
        if (this.rc == null) {
            this.rc = RequestContext.create();
            this.rc.setTraceId(TraceIdUtil.createTraceIdString());
            RequestContextThreadBinder.bind(this.rc);
        } else {
            RequestContext.set(this.rc);
        }
        SetThreadName.setTraceId((String)RequestContext.get().getTraceId());
        String threadName = Thread.currentThread().getName();
        int index = threadName.indexOf("/");
        String tempName = threadName;
        if (index > 0) {
            tempName = threadName.substring(0, index);
        }
        try (TraceSpan span = Tracer.create((String)"ThreadPool", (String)tempName);){
            span.addTag("threadName", threadName);
            span.addTag("tenantId", this.rc.getTenantId());
            span.addTag("accountId", this.rc.getAccountId());
            if (this.oc != null) {
                OperationContext.set((OperationContext)this.oc);
                span.addTag("appId", this.oc.getAppId());
            }
            this.r.run();
        }
        finally {
            if (this.isManaged) {
                ThreadLifeCycleManager.end();
            }
        }
    }
}

