/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.resource.balancer.allocator.threadpool;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import kd.bos.govern.eventdata.EventType;
import kd.bos.govern.eventdata.types.MultiTenantResourceEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.resource.balancer.allocator.ResourceBalanceController;
import kd.bos.resource.balancer.allocator.threadpool.KDThreadPoolExecutor;
import kd.bos.resource.balancer.dimension.DimensionValue;
import kd.bos.resource.balancer.monitor.EventReporter;

public class DiscardPolicyRejectedHandler
implements RejectedExecutionHandler {
    private final Log logger = LogFactory.getLog(DiscardPolicyRejectedHandler.class);

    @Override
    public void rejectedExecution(Runnable k, ThreadPoolExecutor v) {
        if (k instanceof KDThreadPoolExecutor.WRunnable && v instanceof KDThreadPoolExecutor) {
            KDThreadPoolExecutor.WRunnable wRunnable = (KDThreadPoolExecutor.WRunnable)k;
            KDThreadPoolExecutor executor = (KDThreadPoolExecutor)v;
            if (executor.getWorkQueue() != null && executor.getWorkQueue().isPrepareAddWorker()) {
                throw new RejectedExecutionException("Task " + k + " rejected from " + v);
            }
            DimensionValue dimensionValue = wRunnable.dimensionIsolateValue;
            ResourceBalanceController ctl = executor.getResourceBalanceController();
            ctl.getIsolator().incrementRejected(dimensionValue);
            if (wRunnable.hasDeductPermit.get()) {
                ctl.getIsolator().decrementUsing(dimensionValue);
            }
            String msg = String.format("The tenant resource isolation thread pool is full! Rejected from executor => %s", ctl.getDimensionMonitorInfo(dimensionValue));
            MultiTenantResourceEvent.ThreadPoolRejectEvent event = MultiTenantResourceEvent.ThreadPoolRejectEvent.getInstance();
            String eventKey = ctl.getResourceType() + ctl.getResourceName() + dimensionValue.getIsolateValue() + event.getName();
            EventReporter.report(eventKey, (EventType)event, msg);
            this.logger.warn(msg);
        }
    }
}

