/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.resource.balancer.allocator.threadpool;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.resource.balancer.allocator.Callback;
import kd.bos.resource.balancer.allocator.ResourceBalanceController;
import kd.bos.resource.balancer.allocator.threadpool.AbortPolicyRejectedHandler;
import kd.bos.resource.balancer.allocator.threadpool.ContextRunnable;
import kd.bos.resource.balancer.allocator.threadpool.QueueForThreadPool;
import kd.bos.resource.balancer.allocator.threadpool.ResourceMonitor;
import kd.bos.resource.balancer.dimension.DimensionValue;
import kd.bos.resource.balancer.dimension.Isolator;
import kd.bos.resource.balancer.quota.ResourceConfigManage;
import kd.bos.thread.ThreadLifeCycleManager;

public class KDThreadPoolExecutor
extends ThreadPoolExecutor
implements ResourceMonitor {
    private QueueForThreadPool<Runnable> workQueue;
    private int maxPoolSize;
    private AtomicInteger totalRunningThreadCount = new AtomicInteger(0);
    private final ResourceBalanceController ctl;
    String poolName;
    private static ThreadLocal<RetryInfo> retryInfo = new ThreadLocal();

    public KDThreadPoolExecutor(String poolName, int corePoolSize, int maximumPoolSize) {
        this(poolName, corePoolSize, maximumPoolSize, null);
    }

    public ResourceBalanceController getResourceBalanceController() {
        return this.ctl;
    }

    public KDThreadPoolExecutor(final String poolName, int corePoolSize, int maximumPoolSize, String isolateType) {
        super(corePoolSize, maximumPoolSize, 60L, TimeUnit.SECONDS, new QueueForThreadPool<Runnable>(), new ThreadFactory(){
            private AtomicInteger atomicInteger = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, ResourceConfigManage.getThreadName(poolName) + "-" + this.atomicInteger.incrementAndGet());
            }
        }, new AbortPolicyRejectedHandler());
        this.poolName = poolName;
        this.workQueue = (QueueForThreadPool)super.getQueue();
        this.ctl = isolateType == null ? ResourceBalanceController.getController("threadpool", poolName) : ResourceBalanceController.getControllerWithIsolateType("threadpool", poolName, isolateType);
        this.ctl.initMaxResource(maximumPoolSize);
        this.setWorkQueue(this.workQueue);
        this.maxPoolSize = maximumPoolSize;
    }

    private void setWorkQueue(QueueForThreadPool<Runnable> q) {
        this.workQueue.setMonitor(this);
        this.ctl.setQueue(q);
    }

    @Override
    public void execute(Runnable command) {
        final Isolator isolator = this.ctl.getIsolator();
        final ContextRunnable runnableWrap = new ContextRunnable(command, RequestContext.get(), OperationContext.get());
        final WRunnable runnable = new WRunnable(runnableWrap, isolator.getDimensionIsolateValue());
        runnable.bind(RequestContext.get());
        boolean success = this.ctl.submit(new Callback<Runnable>(){

            @Override
            public void call() {
                isolator.incrementUsing(isolator.getDimensionIsolateValue());
                runnable.hasDeductPermit.set(true);
                KDThreadPoolExecutor.this._execute(runnable);
            }

            @Override
            public Runnable getForQueue() {
                return runnable;
            }

            @Override
            public Runnable getOriginal() {
                return runnableWrap.setManaged(true);
            }
        });
        if (!success) {
            this.workQueue.resetPrepareAddWorker();
            super.getRejectedExecutionHandler().rejectedExecution(runnable, this);
        }
    }

    private void _execute(WRunnable runnable) {
        try {
            super.execute(runnable);
        }
        catch (RejectedExecutionException e) {
            RetryInfo info = retryInfo.get();
            if (info == null) {
                info = new RetryInfo(runnable, this);
                retryInfo.set(info);
            }
            if (this.isSameRetryTask(info, runnable, this)) {
                info = new RetryInfo(runnable, this);
                retryInfo.set(info);
            }
            info.incrementRejectTimes();
            if (this.workQueue.isPrepareAddWorker() && info.getRejectTimes() < 100) {
                LockSupport.parkNanos(1000000L);
                this._execute(runnable);
            } else {
                this.workQueue.resetPrepareAddWorker();
                super.getRejectedExecutionHandler().rejectedExecution(runnable, this);
            }
        }
        catch (Throwable t) {
            if (runnable.hasDeductPermit.get()) {
                Isolator isolator = this.ctl.getIsolator();
                isolator.decrementUsing(isolator.getDimensionIsolateValue());
            }
            throw t;
        }
    }

    private boolean isSameRetryTask(RetryInfo retryInfo, WRunnable k, KDThreadPoolExecutor v) {
        return retryInfo.runnable != k || retryInfo.pool != v;
    }

    public QueueForThreadPool<Runnable> getWorkQueue() {
        return this.workQueue;
    }

    @Override
    public int getPoolCount() {
        return this.getPoolSize();
    }

    @Override
    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public int getRunningCount() {
        return this.totalRunningThreadCount.get();
    }

    public class WRunnable
    implements Runnable {
        RequestContext rc;
        Runnable r;
        DimensionValue dimensionIsolateValue;
        public AtomicBoolean hasDeductPermit = new AtomicBoolean(false);

        WRunnable(Runnable r, DimensionValue dimensionIsolateValue) {
            this.r = r;
            this.dimensionIsolateValue = dimensionIsolateValue;
        }

        public void bind(RequestContext rc) {
            this.rc = rc;
        }

        @Override
        public void run() {
            try {
                ThreadLifeCycleManager.start();
                if (!this.hasDeductPermit.get()) {
                    KDThreadPoolExecutor.this.ctl.getIsolator().incrementUsing(this.dimensionIsolateValue);
                }
                KDThreadPoolExecutor.this.totalRunningThreadCount.incrementAndGet();
                KDThreadPoolExecutor.this.ctl.getRecycleManage().mark(Thread.currentThread(), this.rc);
                this.r.run();
            }
            finally {
                KDThreadPoolExecutor.this.ctl.getIsolator().decrementUsing(this.dimensionIsolateValue);
                KDThreadPoolExecutor.this.totalRunningThreadCount.decrementAndGet();
                KDThreadPoolExecutor.this.ctl.getRecycleManage().clearMark(Thread.currentThread());
                ThreadLifeCycleManager.end();
            }
        }
    }

    private static class RetryInfo {
        private int rejectTimes = 0;
        private WRunnable runnable;
        private KDThreadPoolExecutor pool;

        RetryInfo(WRunnable k, KDThreadPoolExecutor v) {
            this.runnable = k;
            this.pool = v;
        }

        public int getRejectTimes() {
            return this.rejectTimes;
        }

        public void incrementRejectTimes() {
            ++this.rejectTimes;
        }
    }
}

