/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.resource.balancer.dimension;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.extension.ExtensionFactory;
import kd.bos.resource.balancer.cap.ResourceCap;
import kd.bos.resource.balancer.cap.ResourceCapMananger;
import kd.bos.resource.balancer.dimension.DimensionValue;
import kd.bos.resource.balancer.dimension.IsolatorDimension;

public class Isolator {
    private static final int DEFAULTISOLATEQUEUESIZE = 1000;
    private static Map<String, Isolator> isolators = new ConcurrentHashMap<String, Isolator>(2);
    private static final ExtensionFactory<IsolatorDimension> lookupFactory = ExtensionFactory.getExtensionFacotry(IsolatorDimension.class);
    private static final String DEFAULTRESOURCETYPE = "threadpool";
    public static final String DEFAULTISOLATEDIMENSION = "account";
    private String resourceType;
    private String resourceName;
    private String isolatorDimensionType = "account";
    private IsolatorDimension isolatorDimension;
    private final ResourceCap resourceCap;

    private Isolator(String resourceType, String resourceName) {
        this.resourceType = resourceType;
        this.resourceName = resourceName;
        this.resourceCap = ResourceCapMananger.getCap(resourceType + resourceName);
        this.initIsolatorDimension();
    }

    private void initIsolatorDimension() {
        if (!lookupFactory.existsExtension(this.isolatorDimensionType)) {
            throw new RuntimeException("not support isolatorDimensionType : " + this.isolatorDimensionType);
        }
        IsolatorDimension id = (IsolatorDimension)lookupFactory.getExtension(this.isolatorDimensionType, false);
        id.setResourceTypeAndName(this.resourceType, this.resourceName, this.resourceCap);
        this.isolatorDimension = id;
    }

    public static Isolator getIsolator(String resourceType, String resourceName) {
        return isolators.computeIfAbsent(resourceType + resourceName, k -> new Isolator(resourceType, resourceName));
    }

    public static Isolator getIsolator(String resourceName) {
        return isolators.computeIfAbsent(DEFAULTRESOURCETYPE + resourceName, k -> new Isolator(DEFAULTRESOURCETYPE, resourceName));
    }

    public Isolator withIsolatorDimension(String dimension) {
        if (dimension != null && dimension.length() > 0 && !dimension.equals(this.isolatorDimensionType)) {
            this.isolatorDimensionType = dimension;
            this.initIsolatorDimension();
        }
        return this;
    }

    public String getIsolatorDimensionType() {
        return this.isolatorDimensionType;
    }

    public ResourceCap getResourceCap() {
        return this.resourceCap;
    }

    public long inUsingForCurIsolation(DimensionValue dimension) {
        return this.isolatorDimension.inUsingForCurIsolation(dimension.getIsolateValue());
    }

    public long getRejectedCount(DimensionValue dimension) {
        return this.isolatorDimension.getRejectedCount(dimension.getIsolateValue());
    }

    public void incrementUsing(DimensionValue dimension) {
        if (this.isolatorDimension != null) {
            this.isolatorDimension.incrementUsing(dimension.getIsolateValue());
        }
        this.resourceCap.incrementUsing();
    }

    public void decrementUsing(DimensionValue dimension) {
        if (this.isolatorDimension != null) {
            this.isolatorDimension.decrementUsing(dimension.getIsolateValue());
        }
        this.resourceCap.decrementUsing();
    }

    public void incrementRejected(DimensionValue dimension) {
        if (this.isolatorDimension != null) {
            this.isolatorDimension.incrementRejected(dimension.getIsolateValue());
        }
    }

    public boolean hasQuota() {
        return this.hasQuota(this.getDimensionIsolateValue());
    }

    public boolean hasQuota(DimensionValue dimension) {
        if (this.resourceCap.left() <= 0L) {
            return false;
        }
        if (this.resourceCap.canOverBorrow()) {
            return true;
        }
        return this.isolatorDimension == null || this.isolatorDimension.hasQuota(dimension.getIsolateValue());
    }

    public long getQuota(DimensionValue dimension) {
        if (this.isolatorDimension != null) {
            return this.isolatorDimension.getQuota(dimension.getIsolateValue());
        }
        return Long.MAX_VALUE;
    }

    public int getPriorityLevel(DimensionValue dimension) {
        if (this.isolatorDimension != null) {
            return this.isolatorDimension.getPriorityLevel(dimension.getIsolateValue());
        }
        return Integer.MAX_VALUE;
    }

    public int getMaxQueueSize(DimensionValue dimension) {
        if (this.isolatorDimension != null) {
            return this.isolatorDimension.getMaxQueueSize(dimension.getIsolateValue());
        }
        return 1000;
    }

    public DimensionValue getDimensionIsolateValue() {
        return new DimensionValue(this.isolatorDimensionType, this.isolatorDimension.getIsolatorKey());
    }

    public void setIsolatorDimensionKey(String s) {
        this.isolatorDimension.setIsolatorKey(s);
    }

    public DimensionValue getDimensionIsolateValue(String v) {
        return new DimensionValue(this.isolatorDimensionType, v);
    }

    public Set<String> getIsolationKeys() {
        return this.isolatorDimension.getIsolationKeys();
    }
}

