/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.resource.balancer.monitor;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.govern.eventdata.EventType;
import kd.bos.govern.eventdata.reporter.EventDataReporter;
import kd.bos.resource.balancer.Configs;

public class EventReporter {
    private static final BlockingQueue<EventData> eventDataQueue = new LinkedBlockingQueue<EventData>(10000);
    private static final Map<String, EventData> eventDataMap = new ConcurrentHashMap<String, EventData>();

    public static void report(String eventKey, EventType eventType, String msg) {
        eventDataQueue.offer(new EventData(eventKey, eventType, System.currentTimeMillis(), msg));
    }

    static {
        Thread reportThread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        EventData poll;
                        if ((poll = eventDataQueue.poll(9000L, TimeUnit.MILLISECONDS)) == null) {
                            continue;
                        }
                        EventData eventData = eventDataMap.get(poll.eventKey);
                        if (eventData == null) {
                            EventDataReporter.report((EventType)poll.eventType, (String)poll.msg);
                            eventDataMap.put(poll.eventKey, poll);
                            continue;
                        }
                        long current = poll.time;
                        if (current - eventData.time < (long)(Configs.getEventDataReporterInterval() * 1000)) continue;
                        EventDataReporter.report((EventType)poll.eventType, (String)poll.msg);
                        eventDataMap.put(poll.eventKey, poll);
                    }
                }
                catch (Exception e) {
                    try {
                        TimeUnit.SECONDS.sleep(3L);
                    }
                    catch (Exception exception) {
                    }
                    continue;
                }
                break;
            }
        }, "MultiTenant-EventData-Report");
        reportThread.setDaemon(true);
        reportThread.start();
    }

    private static class EventData {
        private String eventKey;
        private EventType eventType;
        private long time;
        private String msg;

        public EventData(String eventKey, EventType eventType, long time, String msg) {
            this.eventKey = eventKey;
            this.eventType = eventType;
            this.time = time;
            this.msg = msg;
        }
    }
}

