/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.resource.balancer.monitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestTimeoutContext;
import kd.bos.govern.eventdata.EventType;
import kd.bos.govern.eventdata.types.MultiTenantResourceEvent;
import kd.bos.govern.timeout.ThreadTimeoutManager;
import kd.bos.resource.balancer.Configs;
import kd.bos.resource.balancer.quota.ResourceConfigManage;

public class ResourceRecycleManage {
    private static Map<String, ResourceRecycleManage> resourceRecycleManages = new ConcurrentHashMap<String, ResourceRecycleManage>(6);
    private static final String UNDERLINE = "_";
    private static final String TIMEOUT_SCENE = "MultiTenantResourceRecycle";
    private Map<String, RunningTask> tasks = new ConcurrentHashMap<String, RunningTask>(16);
    private String resourceType;
    private String resourceName;

    private ResourceRecycleManage(String resourceType, String resourceName) {
        this.resourceType = resourceType;
        this.resourceName = resourceName;
    }

    public static ResourceRecycleManage getResourceRecycleManage(String resourceType, String resourceName) {
        return resourceRecycleManages.computeIfAbsent(resourceType + resourceName, k -> new ResourceRecycleManage(resourceType, resourceName));
    }

    public void mark(Thread t, RequestContext rc) {
        String op = this.resourceName + "ThreadPool";
        long startTime = System.currentTimeMillis();
        RequestTimeoutContext context = new RequestTimeoutContext(TIMEOUT_SCENE, op, 10000L);
        context.setStartTime(startTime);
        RequestTimeoutContext.set((RequestTimeoutContext)context);
        String traceId = null;
        RequestContext current = RequestContext.get();
        if (current != null && current.getTraceId() != null) {
            traceId = current.getTraceId();
        } else if (rc != null) {
            traceId = rc.getTraceId();
        }
        long threadId = t.getId();
        String threadName = t.getName();
        this.tasks.put(this.getKey(this.resourceName, String.valueOf(threadId)), new RunningTask(threadId, threadName, traceId, startTime));
    }

    public void clearMark(Thread t) {
        this.tasks.remove(this.getKey(this.resourceName, String.valueOf(t.getId())));
        RequestTimeoutContext context = RequestTimeoutContext.get();
        if (context != null) {
            context.clear();
        }
    }

    public void releaseTimeoutThread() {
        long timeoutThreshold = (long)ResourceConfigManage.getTimeoutThreshold(this.resourceName) * 1000L;
        ArrayList<RunningTask> taskList = new ArrayList<RunningTask>(16);
        taskList.addAll(this.tasks.values());
        Collections.sort(taskList, Comparator.comparingLong(RunningTask::getStartTime));
        double releaseRatio = Math.min((double)Configs.getThreadPoolTimeoutRecyclePercent(this.resourceName).intValue() / 100.0, 1.0);
        long endIndex = Math.round((double)taskList.size() * releaseRatio);
        long current = System.currentTimeMillis();
        int i = 0;
        while ((long)i < endIndex) {
            RunningTask task = (RunningTask)taskList.get(i);
            if (current - task.getStartTime() > timeoutThreshold) {
                ThreadTimeoutManager.terminateRequest((EventType)MultiTenantResourceEvent.getInstance(), (String)task.getTraceId(), (long)task.getThreadId(), (String)task.getThreadName());
            }
            ++i;
        }
    }

    private String getKey(String resourceName, String threadId) {
        return resourceName + UNDERLINE + threadId;
    }

    private static class RunningTask {
        private String resourceName;
        private long threadId;
        private String threadName;
        private String traceId;
        private String accountId;
        private long startTime;

        public RunningTask(long threadId, String threadName, String traceId, long startTime) {
            this.threadId = threadId;
            this.threadName = threadName;
            this.traceId = traceId;
            this.startTime = startTime;
        }

        public RunningTask setResourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public RunningTask setAccountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public long getThreadId() {
            return this.threadId;
        }

        public String getThreadName() {
            return this.threadName;
        }

        public String getTraceId() {
            return this.traceId;
        }

        public long getStartTime() {
            return this.startTime;
        }
    }
}

