/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.response;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.response.ResponseHeader;

public class ResponseHeaderImpl
implements ResponseHeader,
Serializable {
    private static final long serialVersionUID = -5756274401816037827L;
    private static final String COSMIC = "Cosmic-";
    private static final String STATUS = "Cosmic-Status";
    private static final String ERRORCODE = "Cosmic-ErrorCode";
    private static final String NOTSHOWERRORCODEMSG = "response.showerrorcodemsg.disable";
    private static final boolean isNotSHOWERRORCODEMSG = Boolean.getBoolean("response.showerrorcodemsg.disable");
    private static final int MAXLENGTH = Integer.getInteger("response.header.errormsg.maxlength", 200);
    private static Log logger = LogFactory.getLog(ResponseHeaderImpl.class);
    private static ThreadLocal<ResponseHeaderImpl> local = new ThreadLocal<ResponseHeaderImpl>(){

        @Override
        protected ResponseHeaderImpl initialValue() {
            ResponseHeaderImpl rh = new ResponseHeaderImpl();
            return rh;
        }
    };
    private Map<String, String> headers = new HashMap<String, String>(2);

    private ResponseHeaderImpl() {
    }

    protected static ResponseHeaderImpl get() {
        return local.get();
    }

    protected void merge(ResponseHeader header) {
        this.headers.putAll(header.getHeaders());
    }

    @Override
    public void put(String key, String value) {
        if (key != null && value != null) {
            this.headers.put(COSMIC + key, this.encode(value));
        }
    }

    public void error() {
        this.headers.put(STATUS, "0");
    }

    @Override
    public void error(ErrorCode ecode) {
        String code;
        this.error();
        if (ecode == null) {
            ecode = new ErrorCode("empty_code", "empty_msg");
        }
        if ((code = ecode.getCode()) == null || code.trim().length() == 0) {
            code = "empty_error_code";
        }
        String msg = ecode.getMessage();
        String codemsg = code + " : " + msg;
        String errMsg = isNotSHOWERRORCODEMSG ? code : codemsg;
        if ((errMsg = this.encode(errMsg)).length() > MAXLENGTH) {
            errMsg = errMsg.substring(0, MAXLENGTH) + "...";
        }
        this.headers.put(ERRORCODE, errMsg);
    }

    private String encode(String errMsg) {
        if (errMsg.length() > MAXLENGTH) {
            errMsg = errMsg.substring(0, MAXLENGTH) + "...";
        }
        if ((errMsg = errMsg.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&rt;").replaceAll("\"", "&quot;").replaceAll("/", "&#x2f;")).length() > MAXLENGTH) {
            errMsg = errMsg.substring(0, MAXLENGTH) + "...";
        }
        return errMsg;
    }

    @Override
    public void error(KDException exception) {
        logger.error("[ResponseHeaderError]", (Throwable)exception);
        this.error(exception.getErrorCode());
    }

    @Override
    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    protected void sucess() {
        this.headers.put(STATUS, "1");
    }

    protected boolean hasStatus() {
        return this.headers.containsKey(STATUS);
    }
}

