/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.session;

import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.util.resource.Resources;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class RSAUtils {
    private static final String RSA_ECB_PADDING = "RSA/ECB/OAEPPadding";
    private static final String BOS_LOGIN = "bos-login";
    private static final Logger logger = Logger.getLogger(RSAUtils.class);
    private static final ErrorCode ENCRYPT_Exception = RSAUtils.bosException("EncryptException", "%s");
    private static Provider provider = new BouncyCastleProvider();

    private static final ErrorCode bosException(String errorCode, String message) {
        return new ErrorCode("bos." + errorCode, message);
    }

    @Deprecated
    public static KeyPair generateKeyPair() {
        try {
            SecureRandom random = new SecureRandom();
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", provider);
            generator.initialize(1024, random);
            return generator.generateKeyPair();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{Resources.getString((String)"\u751f\u6210keypair\u9519\u8bef_0 ", (String)"RSAUtils_0", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    public static KeyPair generateKeyPair2048() {
        try {
            SecureRandom random = new SecureRandom();
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", provider);
            generator.initialize(2048, random);
            return generator.generateKeyPair();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{Resources.getString((String)"\u751f\u6210keypair\u9519\u8bef_0 ", (String)"RSAUtils_0", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    public static String generateBase64PublicKey(KeyPair keyPair) throws KDException {
        if (keyPair == null) {
            throw new KDException(ENCRYPT_Exception, new Object[]{Resources.getString((String)"\u53c2\u6570keyPair\u4e0d\u80fd\u4e3a\u7a7a_1", (String)"RSAUtils_1", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        return new String(Base64.encodeBase64((byte[])publicKey.getEncoded()));
    }

    public static String generateBase64Key(byte[] keys) throws KDException {
        if (keys == null) {
            throw new KDException(ENCRYPT_Exception, new Object[]{Resources.getString((String)"\u53c2\u6570keys\u4e0d\u80fd\u4e3a\u7a7a_2", (String)"RSAUtils_2", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        return new String(Base64.encodeBase64((byte[])keys));
    }

    public static String decryptBase64(String string, KeyPair keyPair) {
        return new String(RSAUtils.decryptByPrivateKey(keyPair, Base64.decodeBase64((byte[])string.getBytes())));
    }

    private static byte[] decryptByPrivateKey(KeyPair keyPair, byte[] byteArray) {
        try {
            if (keyPair == null) {
                throw new KDException(ENCRYPT_Exception, new Object[]{Resources.getString((String)"\u53c2\u6570keyPair\u4e0d\u80fd\u4e3a\u7a7a_3", (String)"RSAUtils_3", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            Cipher cipher = Cipher.getInstance(RSA_ECB_PADDING, provider);
            PrivateKey privateKey = keyPair.getPrivate();
            cipher.init(2, privateKey);
            byte[] plainText = cipher.doFinal(byteArray);
            return plainText;
        }
        catch (KDException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{Resources.getString((String)"decryptByPrivateKey\u9519\u8bef_4", (String)"RSAUtils_4", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    public static byte[] decryptByKey(Key keys, byte[] byteArray) {
        try {
            if (keys == null) {
                throw new KDException(ENCRYPT_Exception, new Object[]{Resources.getString((String)"\u53c2\u6570keys\u4e0d\u80fd\u4e3a\u7a7a_5", (String)"RSAUtils_5", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            Cipher cipher = Cipher.getInstance(RSA_ECB_PADDING, provider);
            cipher.init(2, keys);
            byte[] plainText = cipher.doFinal(byteArray);
            return plainText;
        }
        catch (KDException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{Resources.getString((String)"decryptByKey\u9519\u8bef_6", (String)"RSAUtils_6", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    private static byte[] decryptByPrivateKey(byte[] keys, byte[] byteArray) {
        try {
            if (keys == null) {
                throw new KDException(ENCRYPT_Exception, new Object[]{Resources.getString((String)"\u53c2\u6570keys\u4e0d\u80fd\u4e3a\u7a7a_7", (String)"RSAUtils_7", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            Cipher cipher = Cipher.getInstance(RSA_ECB_PADDING, provider);
            PrivateKey privateKey = RSAUtils.getPrivateKey(keys);
            cipher.init(2, privateKey);
            byte[] plainText = cipher.doFinal(byteArray);
            return plainText;
        }
        catch (KDException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{Resources.getString((String)"decryptByPrivateKey\u9519\u8bef_8", (String)"RSAUtils_8", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    public static byte[] encryptByPublickKey(KeyPair keyPair, byte[] byteArray) {
        try {
            if (keyPair == null) {
                throw new KDException(ENCRYPT_Exception, new Object[]{Resources.getString((String)"\u53c2\u6570keyPair\u4e0d\u80fd\u4e3a\u7a7a_9", (String)"RSAUtils_9", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            Cipher cipher = Cipher.getInstance(RSA_ECB_PADDING, provider);
            PublicKey publicKey = keyPair.getPublic();
            cipher.init(1, publicKey);
            byte[] plainText = cipher.doFinal(byteArray);
            return plainText;
        }
        catch (KDException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{Resources.getString((String)"encryptByPublickKey\u9519\u8bef_10", (String)"RSAUtils_10", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    public static byte[] encryptByPrivateKey(KeyPair keyPair, byte[] byteArray) {
        try {
            if (keyPair == null) {
                throw new KDException(ENCRYPT_Exception, new Object[]{Resources.getString((String)"\u53c2\u6570keyPair\u4e0d\u80fd\u4e3a\u7a7a_11", (String)"RSAUtils_11", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            Cipher cipher = Cipher.getInstance(RSA_ECB_PADDING, provider);
            PrivateKey privateKey = keyPair.getPrivate();
            cipher.init(1, privateKey);
            byte[] plainText = cipher.doFinal(byteArray);
            return plainText;
        }
        catch (KDException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{Resources.getString((String)"encryptByPrivateKey\u9519\u8bef_12", (String)"RSAUtils_12", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    public static byte[] encryptByKey(Key keys, byte[] byteArray) {
        try {
            if (keys == null) {
                throw new KDException(ENCRYPT_Exception, new Object[]{Resources.getString((String)"\u53c2\u6570keys\u4e0d\u80fd\u4e3a\u7a7a_13", (String)"RSAUtils_13", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            Cipher cipher = Cipher.getInstance(RSA_ECB_PADDING, provider);
            cipher.init(1, keys);
            byte[] plainText = cipher.doFinal(byteArray);
            return plainText;
        }
        catch (KDException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{Resources.getString((String)"encryptByKey\u9519\u8bef_14", (String)"RSAUtils_14", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    public static byte[] encryptByprivateKey(byte[] keys, byte[] byteArray) {
        try {
            if (keys == null) {
                throw new KDException(ENCRYPT_Exception, new Object[]{Resources.getString((String)"\u53c2\u6570keys\u4e0d\u80fd\u4e3a\u7a7a_15", (String)"RSAUtils_15", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            Cipher cipher = Cipher.getInstance(RSA_ECB_PADDING, provider);
            cipher.init(1, RSAUtils.getPrivateKey(keys));
            byte[] plainText = cipher.doFinal(byteArray);
            return plainText;
        }
        catch (KDException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{Resources.getString((String)"encryptByprivateKey\u9519\u8bef_16", (String)"RSAUtils_16", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    public static PublicKey getPublicKey(String key) throws KDException {
        try {
            if (key == null) {
                throw new KDException(ENCRYPT_Exception, new Object[]{Resources.getString((String)"\u53c2\u6570key\u4e0d\u80fd\u4e3a\u7a7a_17", (String)"RSAUtils_17", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            byte[] keyBytes = key.getBytes();
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(keySpec);
            return publicKey;
        }
        catch (KDException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{Resources.getString((String)"getPublicKey\u9519\u8bef_18", (String)"RSAUtils_18", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    public static PublicKey getPublicKey(byte[] keyBytes) throws KDException {
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(keySpec);
            return publicKey;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{Resources.getString((String)"getPublicKey\u9519\u8bef_19", (String)"RSAUtils_19", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    public static PublicKey getPublicKeyBase64(String key) throws KDException {
        try {
            if (key == null) {
                throw new KDException(ENCRYPT_Exception, new Object[]{Resources.getString((String)"\u53c2\u6570key\u4e0d\u80fd\u4e3a\u7a7a_20", (String)"RSAUtils_20", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            byte[] keyBytes = Base64.decodeBase64((String)key);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(keySpec);
            return publicKey;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{Resources.getString((String)"getPublicKeyBase64\u9519\u8bef_21", (String)"RSAUtils_21", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    public static PrivateKey getPrivateKey(String key) throws KDException {
        try {
            byte[] keyBytes = Base64.decodeBase64((String)key);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            return privateKey;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{Resources.getString((String)"getPrivateKey\u9519\u8bef_22", (String)"RSAUtils_22", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    public static PrivateKey getPrivateKey(byte[] keyBytes) throws KDException {
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            return privateKey;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{Resources.getString((String)"getPrivateKey\u9519\u8bef_23", (String)"RSAUtils_23", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    public static PrivateKey getPrivateKeyBase64(String key) throws KDException {
        PrivateKey privateKey = null;
        try {
            if (key == null) {
                throw new KDException(ENCRYPT_Exception, new Object[]{Resources.getString((String)"\u53c2\u6570key\u4e0d\u80fd\u4e3a\u7a7a_24", (String)"RSAUtils_24", (String)BOS_LOGIN, (Object[])new Object[0])});
            }
            byte[] keyBytes = Base64.decodeBase64((String)key);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            privateKey = keyFactory.generatePrivate(keySpec);
            return privateKey;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, ENCRYPT_Exception, new Object[]{Resources.getString((String)"getPrivateKeyBase64\u9519\u8bef_25", (String)"RSAUtils_25", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }

    public static void main(String[] args) {
    }

    static {
        Security.addProvider(provider);
    }
}

