/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.session;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.SessionIdUtils;
import kd.bos.context.RequestContext;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.utils.DateUtils;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.session.SessionInfo;
import kd.bos.session.SessionKeys;
import kd.bos.session.SessionQuery;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.session.service.SessionDBService;
import kd.bos.threads.ThreadPools;
import kd.bos.url.UrlService;
import kd.bos.util.DisCardUtil;
import kd.bos.util.RevProxyUtil;
import kd.bos.util.StringUtils;

public class SessionManager {
    private static final int TIMEOUT_TIMES = 2;
    private static final String USER_ID = "user_id";
    private static final Log log = LogFactory.getLog(SessionManager.class);
    private static final String HTTPS = "https";
    private static final String IS_THREADPOOL = "bos.svc.session.isTreadPool";
    private static final String IS_SYNC_DB = "bos.svc.session.isSyncDB";
    public static final int CPU_NUM = Runtime.getRuntime().availableProcessors();
    private static final ExecutorService exec = ThreadPools.newCachedExecutorService("saveDBSessionPool", CPU_NUM, CPU_NUM * 4);
    private static final String SESSION_ACCOUNT_SPLITSTR = "@@@";
    private static final String CP_CAO_PSA_OUR = "CP=CAO PSA OUR";

    public static String newSession(HttpServletRequest request, HttpServletResponse response, Map<String, String> sessionInfo) {
        return SessionManager.newSession(request, response, sessionInfo, true);
    }

    public static String newSession(HttpServletRequest request, HttpServletResponse response, Map<String, String> sessionInfo, boolean needCopyToClient) {
        String globalSessionId = SessionManager.newSession(sessionInfo);
        String tenantAlias = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        String accountId = sessionInfo.get("accountId");
        if (StringUtils.isBlank((String)accountId)) {
            throw new KDException(new ErrorCode("create session error", "No attributes found for data center!"), new Object[0]);
        }
        if (needCopyToClient) {
            SessionManager.writeCookieData(request, response, SessionKeys.getGlobalCookieSessionkey(tenantAlias, accountId), globalSessionId);
            SessionManager.writeCookieData(request, response, SessionKeys.getGlobalCookieAccountIsolatorKey(tenantAlias), accountId);
        }
        return globalSessionId;
    }

    private static boolean getHttpOnly(String tenantAlias) {
        boolean httpOnly = true;
        String config_httponly = "config_httponly";
        String httpString = System.getProperty(tenantAlias + config_httponly);
        if (httpString == null || httpString.trim().length() == 0) {
            httpString = System.getProperty(config_httponly);
        }
        if ("false".equalsIgnoreCase(httpString)) {
            httpOnly = false;
        }
        return httpOnly;
    }

    private static boolean isSecure(String tenantAlias) {
        boolean isSecure = false;
        String domain = UrlService.getDomainContextUrlByTenantCode(tenantAlias);
        try {
            URI url = new URI(domain);
            if (HTTPS.equalsIgnoreCase(url.getScheme())) {
                isSecure = true;
            }
        }
        catch (URISyntaxException e) {
            log.warn((Throwable)e);
        }
        return isSecure;
    }

    public static String newSession(Map<String, String> sessionInfo) {
        return SessionManager.newSession(sessionInfo, SessionDAO.getSessionTimeout(sessionInfo.get("tenantId")));
    }

    public static String newSession(Map<String, String> sessionInfo, int timeout) {
        sessionInfo.put("kdCsrfToken", StringUtils.randomWord((int)32));
        sessionInfo.put("expiredTime", String.valueOf(DateUtils.plusSecondsWithDate(new Date(), timeout).getTime()));
        String globalSessionId = SessionManager.getSessionIDString(sessionInfo);
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO(globalSessionId);
        sessionDAO.initSessionId(sessionInfo.get("tenantId") + SESSION_ACCOUNT_SPLITSTR + sessionInfo.get("accountId"));
        sessionDAO.setAttributes(sessionInfo);
        sessionDAO.expireAfter(timeout);
        SessionManager.setCacheValue(SessionManager.getSaveString(sessionInfo), globalSessionId, sessionInfo.get("tenantId"));
        SessionInfo sessionObj = SessionManager.getSessionInfo(sessionInfo);
        if (sessionObj != null && SessionManager.isSyncDB()) {
            Date expDate = SessionManager.getExpiredTime(timeout, sessionObj.getLoginTime());
            sessionObj.setExpiredTime(DateUtils.formatDateTime(expDate));
            sessionObj.setGloableSessionId(globalSessionId);
            SessionManager.saveDBSession(sessionObj);
        }
        return globalSessionId;
    }

    private static Date getExpiredTime(int timeout, String loginTime) {
        Date expDate = null;
        if (null != loginTime) {
            expDate = DateUtils.parseDate(loginTime);
        }
        if (null == expDate) {
            expDate = new Date();
        }
        return DateUtils.plusSecondsWithDate(expDate, timeout);
    }

    public static SessionInfo getSessionInfo(Map<String, String> sessionInfo) {
        SessionInfo si = null;
        if (sessionInfo != null) {
            si = new SessionInfo();
            si.setTenantId(sessionInfo.get("tenantId"));
            si.setAccCompany(sessionInfo.get("accCompanyId"));
            si.setAccountId(sessionInfo.get("accountId"));
            si.setOrgId(sessionInfo.get("orgId"));
            si.setUserId(sessionInfo.get("userId"));
            si.setUserName(sessionInfo.get("userName"));
            si.setUserOpenId(sessionInfo.get("userOpenId"));
            si.setUserType(sessionInfo.get("userType"));
            si.setLoginIP(sessionInfo.get("loginIP"));
            si.setLanguage(sessionInfo.get("language"));
            si.setUid(sessionInfo.get("uid"));
            si.setKdCsrfToken(sessionInfo.get("kdCsrfToken"));
            si.setLoginTime(sessionInfo.get("loginTime"));
            si.setYzjAppId(sessionInfo.get("yzjAppId"));
            si.setYzjAppTicket(sessionInfo.get("yzjAppTicket"));
            si.setClient(sessionInfo.get("client"));
            si.setApi3rdAppId(sessionInfo.get("api3rdAppId"));
            si.setApi3rdAppNum(sessionInfo.get("api3rdAppNum"));
            si.setBizPartnerId(sessionInfo.get("bizPartnerId"));
        }
        return si;
    }

    private static String getSessionIDString(Map<String, String> sessionInfo) {
        return sessionInfo.get("accountId") + "_" + StringUtils.randomWord((int)100) + SessionIdUtils.getHourSubOfDay();
    }

    private static String getSaveString(Map<String, String> sessionInfo) {
        String returnString = "";
        if (sessionInfo != null) {
            StringBuilder sb = new StringBuilder(sessionInfo.get("userId"));
            sb.append(",").append(sessionInfo.get("orgId"));
            sb.append(",").append(sessionInfo.get("client"));
            sb.append(",").append(sessionInfo.get("accountId"));
            sb.append(",").append(sessionInfo.get("tenantId"));
            if (StringUtils.isNotEmpty((String)sessionInfo.get("loginIP"))) {
                sb.append(",").append(sessionInfo.get("loginIP").split(",")[0]);
            } else {
                sb.append(",").append("");
            }
            sb.append(",").append(sessionInfo.get("language"));
            returnString = sb.toString();
        }
        return returnString;
    }

    public static String newSession(HttpServletRequest request, HttpServletResponse response, SessionInfo sessionInfo, boolean needCopyToClient) {
        return SessionManager.newSession(request, response, sessionInfo.toMap(), needCopyToClient);
    }

    public static String newSession(SessionInfo sessionInfo) {
        return SessionManager.newSession(sessionInfo.toMap());
    }

    public static String newSession(SessionInfo sessionInfo, int timeout) {
        return SessionManager.newSession(sessionInfo.toMap(), timeout);
    }

    public static String newSession(String orgId, String tenantId, String userId, String userName, String userOpenID, String IP) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, String> sessionInfo = new HashMap<String, String>();
        sessionInfo.put("orgId", orgId);
        sessionInfo.put("tenantId", tenantId);
        sessionInfo.put("userId", userId);
        sessionInfo.put("userName", userName);
        sessionInfo.put("userOpenId", userOpenID);
        sessionInfo.put("loginTime", df.format(new Date()));
        sessionInfo.put("loginIP", IP);
        String globalSessionId = SessionIdUtils.newSessionId();
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO(globalSessionId);
        sessionDAO.initSessionId(tenantId);
        sessionDAO.setAttributes(sessionInfo);
        sessionDAO.expireAfter(SessionDAO.getSessionTimeout(tenantId));
        SessionManager.setCacheValue(SessionManager.getSaveString(sessionInfo), globalSessionId, tenantId);
        return globalSessionId;
    }

    public static String getUserIdFromCach(String globalSessionId) {
        String userId = null;
        if (StringUtils.isNotEmpty((String)globalSessionId)) {
            userId = CacheLoginData.getAttribute(USER_ID, globalSessionId);
        }
        return userId;
    }

    private static void setCacheValue(String value, String globalSessionId, String tenantId) {
        CacheLoginData.setAttribute(USER_ID, globalSessionId, value, SessionDAO.getSessionTimeout(tenantId) * 2);
    }

    public static void expireCacheValue(String globalSessionId, int timeout) {
        CacheLoginData.expire(USER_ID, globalSessionId, timeout);
    }

    private static Account getAccountBySessionId(SessionDAO sessionDAO, String globalSessionId) {
        Map<String, String> sessionInfo;
        Account account = null;
        if (sessionDAO != null && StringUtils.isNotEmpty((String)globalSessionId) && (sessionInfo = sessionDAO.getAttributesAsMap(new String[]{"tenantId", "sandboxId", "language", "userId", "userName", "userOpenId", "orgId", "userType", "yzjAppId", "yzjAppTicket", "accountId", "uid", "loginOrg", "client"})) != null && sessionInfo.get("accountId") != null) {
            String accountId = sessionInfo.get("accountId");
            String tenatId = sessionInfo.get("tenantId");
            account = AccountUtils.getCorrectAccount((String)accountId, (String)tenatId);
        }
        return account;
    }

    public static void removeCacheValue(String globalSessionId) {
        CacheLoginData.remove(USER_ID, globalSessionId);
    }

    public static String removeSession(HttpServletRequest request, HttpServletResponse response, String globalSessionId) {
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO(globalSessionId);
        Account account = SessionManager.getAccountBySessionId(sessionDAO, globalSessionId);
        String accountId = "";
        if (account != null) {
            accountId = account.getAccountId();
            SessionManager.removeDBSession(account, globalSessionId);
        }
        sessionDAO.remove();
        SessionManager.removeCacheValue(globalSessionId);
        String tenantAlias = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        boolean isSecure = SessionManager.isSecure(tenantAlias);
        Cookie cookie = new Cookie(SessionKeys.getGlobalCookieSessionkey(tenantAlias, accountId), null);
        cookie.setSecure(isSecure);
        cookie.setPath(SessionManager.getPath(tenantAlias));
        cookie.setMaxAge(0);
        boolean httpOnly = SessionManager.getHttpOnly(tenantAlias);
        if (httpOnly) {
            cookie.setHttpOnly(true);
        }
        response.addCookie(cookie);
        return globalSessionId;
    }

    public static void removeSession(String globalSessionId) {
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO(globalSessionId);
        Account account = SessionManager.getAccountBySessionId(sessionDAO, globalSessionId);
        sessionDAO.remove();
        if (account != null) {
            SessionManager.removeDBSession(account, globalSessionId);
        }
        SessionManager.removeCacheValue(globalSessionId);
    }

    public static String newSession(String tenantId, String accountId, String userId, int timeout) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, String> sessionInfo = new HashMap<String, String>();
        sessionInfo.put("accountId", accountId);
        sessionInfo.put("tenantId", tenantId);
        sessionInfo.put("userId", userId);
        sessionInfo.put("loginTime", df.format(new Date()));
        return SessionManager.newSession(sessionInfo, timeout);
    }

    public static void editOrgSessionByUserId(String accountId, String userId, String orgId) {
        List<String> sessionList = SessionQuery.getUserSessions(accountId, userId);
        if (sessionList != null && sessionList.size() > 0) {
            for (String sessionId : sessionList) {
                SessionManager.editSessionValue(sessionId, "orgId", orgId);
            }
        }
    }

    public static void editOrgSession(String orgId) {
        HashMap<String, String> sessionInfo = new HashMap<String, String>();
        sessionInfo.put("orgId", orgId);
        SessionDAO sessionDAO = SessionDAOFactory.get();
        if (sessionDAO != null) {
            sessionDAO.setAttributes(sessionInfo);
        }
    }

    public static void editLoginOrgSession(String orgCode) {
        HashMap<String, String> sessionInfo = new HashMap<String, String>();
        sessionInfo.put("loginOrg", orgCode);
        SessionDAO sessionDAO = SessionDAOFactory.get();
        if (sessionDAO != null) {
            sessionDAO.setAttributes(sessionInfo);
        }
    }

    public static void copySession(HttpServletRequest request, HttpServletResponse response, String globalSessionId) {
        String tenantAlias = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO(globalSessionId);
        Account account = SessionManager.getAccountBySessionId(sessionDAO, globalSessionId);
        if (account == null) {
            throw new KDException(new ErrorCode("create session error", "No attributes found for data center!"), new Object[0]);
        }
        SessionManager.writeCookieData(request, response, SessionKeys.getGlobalCookieSessionkey(tenantAlias, account.getAccountId()), globalSessionId);
        SessionManager.writeCookieData(request, response, SessionKeys.getGlobalCookieAccountIsolatorKey(tenantAlias), account.getAccountId());
    }

    public static String copySession(SessionInfo sessionInfo, int timeout) {
        String globalSessionId = SessionIdUtils.newSessionId();
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO(globalSessionId);
        sessionDAO.initSessionId(sessionInfo.getTenantId() + SESSION_ACCOUNT_SPLITSTR + sessionInfo.getAccountId());
        sessionDAO.setAttributes(sessionInfo.toMap());
        sessionDAO.expireAfter(timeout);
        SessionManager.setCacheValue(SessionManager.getSaveString(sessionInfo.toMap()), globalSessionId, sessionInfo.getTenantId());
        return globalSessionId;
    }

    public static void editSessionValue(String sessionId, String key, String value) {
        HashMap<String, String> sessionInfo = new HashMap<String, String>();
        sessionInfo.put(key, value);
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO(sessionId);
        if (sessionDAO != null) {
            sessionDAO.setAttributes(sessionInfo);
        }
    }

    public static String getCSRFTokenValue(String sessionId) {
        String returnValue = SessionManager.getAttributeFromSession(sessionId, "kdCsrfToken");
        return returnValue;
    }

    public static String getAttributeFromSession(String sessionId, String key) {
        SessionDAO sessionDAO;
        Map<String, String> sessionInfo;
        String returnValue = "";
        if (StringUtils.isNotEmpty((String)sessionId) && (sessionInfo = (sessionDAO = SessionDAOFactory.getSessionDAO(sessionId)).getAttributesAsMap(new String[]{key})) != null && sessionInfo.size() > 0) {
            returnValue = sessionInfo.get(key);
        }
        return returnValue;
    }

    public static Map<String, String> getSessionOrgByUserId(String accountId, String userId) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        List<String> sessionList = SessionQuery.getUserSessions(accountId, userId);
        if (sessionList != null && sessionList.size() > 0) {
            for (String sessionId : sessionList) {
                String org = SessionManager.getAttributeFromSession(sessionId, "orgId");
                returnMap.put(sessionId, org);
            }
        }
        return returnMap;
    }

    public static void writeCookieData(HttpServletRequest request, HttpServletResponse response, String name, String value) {
        String tenantAlias = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        Cookie cookie = new Cookie(name, value);
        boolean isSecure = SessionManager.isSecure(tenantAlias);
        boolean httpOnly = SessionManager.getHttpOnly(tenantAlias);
        cookie.setSecure(isSecure);
        if (httpOnly) {
            cookie.setHttpOnly(true);
        }
        cookie.setPath(SessionManager.getPath(tenantAlias));
        response.setHeader("P3P", CP_CAO_PSA_OUR);
        response.addCookie(cookie);
    }

    private static String getPath(String tenantAlias) {
        String root = "/";
        String pathString = SystemPropertyUtils.getProptyByTenant("cookie_domain_path", tenantAlias);
        if (StringUtils.isNotEmpty((String)pathString)) {
            return root + pathString.trim();
        }
        return root;
    }

    public static String getCookieDataByName(HttpServletRequest request, String name) {
        String value = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                value = cookie.getValue();
            }
        }
        return value;
    }

    public static void touchSession(String sessionId) {
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO(sessionId);
        if (sessionDAO != null) {
            sessionDAO.touchSession();
        }
    }

    public static void removeDBSession(final Account currentAccount, final String sessionId) {
        if (SessionManager.isSyncDB()) {
            ThreadPools.executeOnce("removeDBSession", new Runnable(){

                @Override
                public void run() {
                    SessionDBService.removeSession(currentAccount, sessionId);
                }
            });
        }
    }

    public static void refressSessionBySessionId(final String key, final int timeout) {
        try {
            ThreadPools.executeOnce("refressSessionBySessionId", new Runnable(){

                @Override
                public void run() {
                    SessionDBService.refreshSession(SessionIdUtils.getAccountByKey(key), key, DateUtils.plusSecondsWithDate(new Date(), timeout));
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void refreshBatchSession(final Account account, final List<Object[]> insertData) {
        try {
            if (SessionManager.isSyncDB()) {
                ThreadPools.executeOnce("refreshBatchSession", new Runnable(){

                    @Override
                    public void run() {
                        SessionDBService.refreshBatchSession(account, insertData);
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void saveDBSession(final SessionInfo sessionObj) {
        if (SessionManager.isSyncDB()) {
            exec.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        SessionDBService.saveSession(sessionObj);
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                    }
                }
            });
        } else {
            try {
                ThreadPools.executeOnce("saveDBSession", new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SessionDBService.saveSession(sessionObj);
                        }
                        catch (Exception e) {
                            log.error((Throwable)e);
                        }
                    }
                });
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
            }
        }
    }

    private static boolean isSyncDB() {
        try {
            if (RequestContext.get() != null) {
                return "true".equals(SystemPropertyUtils.getProptyByTenant(IS_SYNC_DB, RequestContext.get().getTenantId()));
            }
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
        return false;
    }
}

