/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.session.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.login.utils.DateUtils;
import kd.bos.session.SessionInfo;
import kd.bos.session.service.DBUtils;
import kd.bos.util.StringUtils;

public class SessionDBService {
    public static final String T_BAS_SESSION_HISTORY = "t_bas_session_history";

    public static List<SessionInfo> getAllSessions() {
        Account currentAcount = AccountUtils.getCorrectAccount((String)RequestContext.get().getAccountId(), (String)RequestContext.get().getTenantId());
        return SessionDBService.getAllSessions(currentAcount);
    }

    public static List<SessionInfo> getAllSessions(Account account) {
        String filter = "";
        return SessionDBService.getAllSessionsByFilter(account, filter);
    }

    public static List<SessionInfo> getAllWEBSessions(Account account) {
        StringBuilder filter = new StringBuilder();
        filter.append(" and ").append(DBUtils.getColumn("client")).append("='web'");
        return SessionDBService.getAllSessionsByFilter(account, filter.toString());
    }

    private static List<SessionInfo> getAllSessionsByFilter(Account account, String filter) {
        String tableName = T_BAS_SESSION_HISTORY;
        ArrayList sessionList = new ArrayList(8);
        String columns = SessionDBService.getQueryColumnString(tableName);
        StringBuilder sql = new StringBuilder("select ").append(columns).append(" from t_bas_session_history  where fuserid  > 0 and flogouttime is null ");
        if (StringUtils.isNotEmpty((String)filter)) {
            sql.append(filter);
        }
        ResultSetHandler rsh = rs -> {
            while (rs.next()) {
                SessionInfo session = new SessionInfo();
                session.setGloableSessionId(Encrypters.decode((String)rs.getString(DBUtils.getColumn("sessionid"))));
                session.setAccCompany(rs.getString(DBUtils.getColumn("acccompanyid")));
                session.setApi3rdAppId(rs.getString(DBUtils.getColumn("api3rdappid")));
                session.setApi3rdAppNum(rs.getString(DBUtils.getColumn("api3rdappnum")));
                session.setBizPartnerId(rs.getString(DBUtils.getColumn("bizpartnerid")));
                session.setClient(rs.getString(DBUtils.getColumn("client")));
                session.setCreatTime(rs.getDate(DBUtils.getColumn("createtime")));
                session.setKdCsrfToken(Encrypters.decode((String)rs.getString(DBUtils.getColumn("kdcsrftoken"))));
                session.setLanguage(rs.getString(DBUtils.getColumn("language")));
                session.setLoginIP(rs.getString(DBUtils.getColumn("loginip")));
                session.setLoginOrg(rs.getString(DBUtils.getColumn("loginorg")));
                session.setLoginTime(rs.getString(DBUtils.getColumn("logintime")));
                session.setModifyTime(rs.getDate(DBUtils.getColumn("modifytime")));
                session.setModifyUser(rs.getString(DBUtils.getColumn("modifierid")));
                session.setOrgId(rs.getString(DBUtils.getColumn("orgid")));
                session.setUid(rs.getString(DBUtils.getColumn("userid")));
                session.setUserId(rs.getString(DBUtils.getColumn("userid")));
                session.setUserName(rs.getString(DBUtils.getColumn("username")));
                session.setUserOpenId(rs.getString(DBUtils.getColumn("useropenid")));
                session.setUserType(rs.getString(DBUtils.getColumn("usertype")));
                session.setYzjAppId(rs.getString(DBUtils.getColumn("yzjappid")));
                session.setYzjAppTicket(rs.getString(DBUtils.getColumn("yzjappticket")));
                sessionList.add(session);
            }
            return sessionList;
        };
        List list = null;
        try {
            list = (List)DBUtils.query(account, DBRoute.basedata, sql.toString(), null, rsh);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public static List<String> getAllSessionsByUserId(Account account, String userId) {
        ArrayList<String> sessionList = new ArrayList<String>();
        if (account == null || !StringUtils.isNumericString((String)userId)) {
            return sessionList;
        }
        String columns = SessionDBService.getQueryColumnString("T_BAS_SESSIONS");
        StringBuilder sql = new StringBuilder("select fid from T_BAS_SESSIONS where fuserid =? and fexpiredtime>?");
        ResultSetHandler rsh = rs -> {
            while (rs.next()) {
                sessionList.add(Encrypters.decode((String)rs.getString(DBUtils.getColumn("id"))));
            }
            return sessionList;
        };
        List list = null;
        try {
            Object[] params = new Object[]{Long.parseLong(userId), new Date()};
            list = (List)DBUtils.query(account, DBRoute.basedata, sql.toString(), params, rsh);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public static boolean saveSession(SessionInfo session) {
        boolean isSucceed = true;
        if (session != null) {
            String sql = "insert into T_BAS_SESSIONS( " + SessionDBService.getQueryColumnString("T_BAS_SESSIONS") + " ) values (" + "?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            Object[] params = new Object[23];
            int i = 0;
            params[i++] = Encrypters.encode((String)session.getGloableSessionId());
            params[i++] = DBUtils.getNonNullString(session.getAccCompany());
            params[i++] = DBUtils.getNonNullString(session.getApi3rdAppId());
            params[i++] = DBUtils.getNonNullString(session.getApi3rdAppNum());
            params[i++] = SessionDBService.parseLongValue(session.getBizPartnerId());
            params[i++] = DBUtils.getNonNullString(session.getClient());
            params[i++] = new Date();
            params[i++] = SessionDBService.getDateObj(session.getExpiredTime());
            params[i++] = Encrypters.encode((String)DBUtils.getNonNullString(session.getKdCsrfToken()));
            params[i++] = DBUtils.getNonNullString(session.getLanguage());
            params[i++] = DBUtils.getNonNullString(session.getLoginIP());
            params[i++] = SessionDBService.parseLongValue(session.getLoginOrg());
            params[i++] = SessionDBService.getDateObj(session.getLoginTime());
            params[i++] = new Date();
            params[i++] = SessionDBService.parseLongValue(session.getModifyUser());
            params[i++] = SessionDBService.parseLongValue(session.getOrgId());
            params[i++] = SessionDBService.parseLongValue(session.getUid());
            params[i++] = SessionDBService.parseLongValue(session.getUserId());
            params[i++] = DBUtils.getNonNullString(session.getUserName());
            params[i++] = DBUtils.getNonNullString(session.getUserOpenId());
            params[i++] = DBUtils.getNonNullString(session.getUserType());
            params[i++] = DBUtils.getNonNullString(session.getYzjAppId());
            params[i++] = DBUtils.getNonNullString(session.getYzjAppTicket());
            Account account = AccountUtils.getCorrectAccount((String)session.getAccountId(), (String)session.getTenantId());
            isSucceed = DBUtils.execute(account, DBRoute.basedata, sql, params);
        }
        return isSucceed;
    }

    private static Object getDateObj(String loginTime) {
        return loginTime != null ? DateUtils.parseDate(loginTime) : new Date();
    }

    public static boolean removeSession(Account account, String sessionId) {
        boolean isSucceed = true;
        if (StringUtils.isNotEmpty((String)sessionId)) {
            String sql = "delete from T_BAS_SESSIONS where " + DBUtils.getColumn("id") + " = ?";
            Object[] params = new Object[]{Encrypters.encode((String)sessionId)};
            isSucceed = DBUtils.execute(account, DBRoute.basedata, sql, params);
        }
        return isSucceed;
    }

    public static boolean refreshSession(Account account, String sessionId, Date refreshDate) {
        boolean isSucceed = true;
        if (StringUtils.isNotEmpty((String)sessionId)) {
            String sql = "update  T_BAS_SESSIONS set  " + DBUtils.getColumn("expiredtime") + "=?  where " + DBUtils.getColumn("id") + " = ?";
            Object[] params = new Object[]{refreshDate, Encrypters.encode((String)sessionId)};
            isSucceed = DBUtils.execute(account, DBRoute.basedata, sql, params);
        }
        return isSucceed;
    }

    public static SqlParameter[] getSqlParameter(String sessionId, Date refreshDate) {
        SqlParameter[] params = new SqlParameter[]{new SqlParameter(":fexpiredtime", 91, (Object)refreshDate), new SqlParameter(":FID", 12, (Object)Encrypters.encode((String)sessionId))};
        return params;
    }

    public static boolean refreshBatchSession(Account account, List<Object[]> insertData) {
        boolean isSucceed = true;
        if (insertData != null && insertData.size() > 0) {
            String sql = "update  T_BAS_SESSIONS set  " + DBUtils.getColumn("expiredtime") + "=?  where " + DBUtils.getColumn("id") + " = ?";
            isSucceed = DBUtils.executeBatch(account, DBRoute.basedata, sql, insertData);
        }
        return isSucceed;
    }

    private static Long parseLongValue(String numString) {
        long returnValue = 0L;
        if (StringUtils.isNotEmpty((String)numString) && StringUtils.isNumeric((String)numString)) {
            try {
                returnValue = Long.parseLong(numString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return returnValue;
    }

    private static String getQueryColumnString(String tableName) {
        StringBuilder colums = new StringBuilder();
        colums.append(DBUtils.getColumn("id"));
        colums.append(",").append(DBUtils.getColumn("acccompanyid"));
        colums.append(",").append(DBUtils.getColumn("api3rdappid"));
        colums.append(",").append(DBUtils.getColumn("api3rdappnum"));
        colums.append(",").append(DBUtils.getColumn("bizpartnerid"));
        colums.append(",").append(DBUtils.getColumn("client"));
        colums.append(",").append(DBUtils.getColumn("createtime"));
        colums.append(",").append(DBUtils.getColumn("expiredtime"));
        colums.append(",").append(DBUtils.getColumn("kdcsrftoken"));
        colums.append(",").append(DBUtils.getColumn("language"));
        colums.append(",").append(DBUtils.getColumn("loginip"));
        colums.append(",").append(DBUtils.getColumn("loginorg"));
        colums.append(",").append(DBUtils.getColumn("logintime"));
        colums.append(",").append(DBUtils.getColumn("modifytime"));
        colums.append(",").append(DBUtils.getColumn("modifierid"));
        colums.append(",").append(DBUtils.getColumn("orgid"));
        if (!T_BAS_SESSION_HISTORY.equals(tableName)) {
            colums.append(",").append(DBUtils.getColumn("uid"));
        }
        colums.append(",").append(DBUtils.getColumn("userid"));
        colums.append(",").append(DBUtils.getColumn("username"));
        colums.append(",").append(DBUtils.getColumn("useropenid"));
        colums.append(",").append(DBUtils.getColumn("usertype"));
        colums.append(",").append(DBUtils.getColumn("yzjappid"));
        colums.append(",").append(DBUtils.getColumn("yzjappticket"));
        if (T_BAS_SESSION_HISTORY.equals(tableName)) {
            colums.append(",").append(DBUtils.getColumn("sessionid"));
        }
        return colums.toString();
    }
}

