/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.threads.impl;

import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.context.RequestContextThreadBinder;
import kd.bos.thread.SetThreadName;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.util.TraceIdUtil;

public class RequestContextRunnable
implements Runnable {
    private RequestContext rc;
    private final Runnable r;
    private final OperationContext oc;

    public RequestContextRunnable(Runnable r, RequestContext rc) {
        this(r, rc, null);
    }

    public RequestContextRunnable(Runnable r, RequestContext rc, OperationContext oc) {
        if (rc != null) {
            this.rc = RequestContext.copy(rc);
        }
        this.r = r;
        this.oc = oc;
    }

    @Override
    public void run() {
        String traceId = TraceIdUtil.createTraceIdString();
        if (this.rc != null) {
            this.rc.setTraceId(traceId);
            RequestContextCreator.restoreForThreadPool(this.rc);
        } else {
            this.rc = RequestContext.create();
            this.rc.setTraceId(traceId);
            RequestContextThreadBinder.bind(this.rc);
        }
        SetThreadName.setTraceId((String)RequestContext.get().getTraceId());
        String threadName = Thread.currentThread().getName();
        int index = threadName.indexOf("/");
        String tempName = threadName;
        if (index > 0) {
            tempName = threadName.substring(0, index);
        }
        try (TraceSpan span = Tracer.create((String)"ThreadPool", (String)tempName);){
            span.addTag("threadName", threadName);
            span.addTag("tenantId", this.rc.getTenantId());
            span.addTag("accountId", this.rc.getAccountId());
            if (this.oc != null) {
                OperationContext.set((OperationContext)this.oc);
                span.addTag("appId", this.oc.getAppId());
            }
            this.r.run();
        }
    }
}

