/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.threads.impl;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.threads.ThreadPool;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class ThreadPoolImpl
implements ThreadPool {
    private final ExecutorService es;
    private OperationContext oc;
    private Consumer<Boolean> closeCallBack;

    @Deprecated
    public ThreadPoolImpl(ExecutorService es) {
        this.es = es;
        this.oc = null;
    }

    @Deprecated
    public ThreadPoolImpl(ExecutorService es, OperationContext oc) {
        this(es, oc, null);
    }

    public ThreadPoolImpl(ExecutorService es, OperationContext oc, Consumer<Boolean> closeCallBack) {
        this.es = es;
        this.oc = oc;
        this.closeCallBack = closeCallBack;
    }

    @Override
    public void execute(Runnable command) {
        this.execute(command, RequestContextCreator.createForThreadPool());
    }

    @Override
    public void execute(Runnable command, RequestContext rc) {
        this.es.execute(() -> {
            RequestContextCreator.restoreForThreadPool(rc);
            try (TraceSpan span = Tracer.create((String)"ThreadPool", (String)"execute");){
                span.addTag("threadName", Thread.currentThread().getName());
                span.addTag("tenantId", rc.getTenantId());
                span.addTag("accountId", rc.getAccountId());
                if (this.oc != null) {
                    OperationContext.set((OperationContext)this.oc);
                    span.addTag("appId", this.oc.getAppId());
                }
                command.run();
            }
        });
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.submit(task, RequestContextCreator.createForThreadPool());
    }

    @Override
    public <T> Future<T> submit(Callable<T> task, RequestContext rc) {
        return this.es.submit(() -> {
            RequestContextCreator.restoreForThreadPool(rc);
            try (TraceSpan span = Tracer.create((String)"ThreadPool", (String)"submit");){
                span.addTag("threadName", Thread.currentThread().getName());
                span.addTag("tenantId", rc.getTenantId());
                span.addTag("accountId", rc.getAccountId());
                if (this.oc != null) {
                    OperationContext.set((OperationContext)this.oc);
                    span.addTag("appId", this.oc.getAppId());
                }
                Object v = task.call();
                return v;
            }
        });
    }

    @Override
    public void close() {
        this.es.shutdown();
        if (this.closeCallBack != null) {
            this.closeCallBack.accept(true);
        }
    }

    @Override
    @Deprecated
    public void executeIncludeRequestContext(Runnable command) {
        this.execute(command);
    }

    @Override
    @Deprecated
    public void executeIncludeRequestContext(Runnable command, RequestContext rc) {
        this.execute(command, rc);
    }
}

