/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.ResourceLeakDetector;
import java.net.InetSocketAddress;
import kd.bos.xcache.server.ServerContext;
import kd.bos.xcache.server.common.SetFuture;
import kd.bos.xcache.server.common.ThreadFactories;
import kd.bos.xcache.server.config.ServerPlatform;
import kd.bos.xcache.server.dispatch.DispatchCenter;
import kd.bos.xcache.server.env.Environment;
import kd.bos.xcache.server.env.HostingEnvironment;
import kd.bos.xcache.server.exception.CacheServerRuntimeException;
import kd.bos.xcache.server.exception.ErrorCode;
import kd.bos.xcache.server.invoker.CommandInvokers;
import kd.bos.xcache.server.mem.ByteBufAllocatorHolder;
import kd.bos.xcache.server.metric.MemoryMetrics;
import kd.bos.xcache.server.metric.MetricsCenter;
import kd.bos.xcache.server.metric.ServerMetrics;
import kd.bos.xcache.server.net.HandlerNames;
import kd.bos.xcache.server.net.ServerChannelInitializer;
import kd.bos.xcache.server.net.enhance.NioServerSocketChannelEnhance;
import kd.bos.xcache.server.schedule.ScheduleTaskManager;
import kd.bos.xcache.server.util.Sizes;

public class Bootstrap {
    private final int port;
    private final SetFuture<Integer> portHolder;
    private final Environment environment;
    private DispatchCenter dispatchCenter;
    private ScheduleTaskManager taskManager;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workGroup;

    public Bootstrap() {
        ServerPlatform.init();
        this.port = ServerPlatform.serverPort();
        this.portHolder = new SetFuture();
        this.environment = HostingEnvironment.get();
    }

    public Bootstrap(Environment environment) {
        ServerPlatform.init();
        this.port = ServerPlatform.serverPort();
        this.portHolder = new SetFuture();
        this.environment = environment;
    }

    public Bootstrap(int port) {
        ServerPlatform.init();
        this.port = port;
        this.portHolder = new SetFuture();
        this.environment = HostingEnvironment.get();
    }

    public int getPort() throws InterruptedException {
        return this.portHolder.get();
    }

    public void startAndSync() {
        try {
            ChannelFuture future = this.doStart();
            future.channel().closeFuture().sync();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.doShutdown();
        }
    }

    public boolean start() {
        return this.doStart().isSuccess();
    }

    public void stop() {
        this.doShutdown();
    }

    private ChannelFuture doStart() {
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)(ServerPlatform.isServerTestMode() ? ResourceLeakDetector.Level.ADVANCED : ResourceLeakDetector.Level.SIMPLE));
        MetricsCenter.init(this.environment.metricRegistry());
        long maxMemoryForData = Runtime.getRuntime().maxMemory() - ServerPlatform.overheadMemory();
        this.dispatchCenter = ServerPlatform.isDispatchWithExtraThread() ? DispatchCenter.newExtraThreadDispatcher(maxMemoryForData, ServerPlatform.partitionSize()) : DispatchCenter.newDirectDispatcher(maxMemoryForData, ServerPlatform.partitionSize());
        CommandInvokers commandInvokers = CommandInvokers.create(this.dispatchCenter);
        long maxMemoryForAllocator = Sizes.percent(maxMemoryForData, Math.min(ServerPlatform.allocatorCapacityPercent(), 100));
        ByteBufAllocatorHolder allocatorHolder = ByteBufAllocatorHolder.create(maxMemoryForAllocator, commandInvokers);
        ServerContext context = new ServerContext(this.dispatchCenter, commandInvokers, allocatorHolder);
        this.taskManager = new ScheduleTaskManager(context);
        this.bossGroup = new NioEventLoopGroup(ThreadFactories.get().newNamedDaemon("nioEventLoopGroup-boss-"));
        this.workGroup = new NioEventLoopGroup(ThreadFactories.get().newNamedDaemon("nioEventLoopGroup-work-"));
        this.registerShutdownHook();
        try {
            this.dispatchCenter.open();
            this.taskManager.start();
            ServerBootstrap b = new ServerBootstrap();
            b.option(ChannelOption.ALLOCATOR, (Object)allocatorHolder.getAllocator());
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.channel(NioServerSocketChannelEnhance.class)).group(this.bossGroup, this.workGroup).handler((ChannelHandler)new LoggingHandler(HandlerNames.SERVER_CHANNEL.name(), LogLevel.INFO))).option(ChannelOption.SO_BACKLOG, (Object)1024)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)allocatorHolder.getAllocator()).childHandler((ChannelHandler)new ServerChannelInitializer(context));
            ChannelFuture future = b.bind(this.port).sync();
            this.portHolder.set(((InetSocketAddress)future.channel().localAddress()).getPort());
            MetricsCenter.get().register(new ServerMetrics(this.environment, this.portHolder.get()));
            MetricsCenter.get().register(new MemoryMetrics());
            return future;
        }
        catch (Exception e) {
            this.doShutdown();
            throw new CacheServerRuntimeException(ErrorCode.ERROR, (Throwable)e);
        }
    }

    private void registerShutdownHook() {
        String threadName = String.format("%s%s", ThreadFactories.get().getGlobalPrefix(), "shutdown");
        Runtime.getRuntime().addShutdownHook(new Thread(this::doShutdown, threadName));
    }

    private void doShutdown() {
        if (this.portHolder != null && this.portHolder.getDirct() == null) {
            this.portHolder.set(0);
        }
        if (this.workGroup != null) {
            this.workGroup.shutdownGracefully();
        }
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
        }
        if (this.dispatchCenter != null) {
            this.dispatchCenter.close();
        }
        if (this.taskManager != null) {
            this.taskManager.stop();
        }
    }
}

