/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.handler;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.xcache.server.cmd.context.CommandContext;
import kd.bos.xcache.server.cmd.handler.AbstractCommandHandler;
import kd.bos.xcache.server.cmd.handler.Values;
import kd.bos.xcache.server.cmd.model.HMGetCommand;
import kd.bos.xcache.server.exception.ErrorCode;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.protocol.Value;
import kd.bos.xcache.server.result.Results;
import kd.bos.xcache.server.result.model.Result;
import kd.bos.xcache.server.store.basic.BufferString;
import kd.bos.xcache.server.store.data.CacheObject;
import kd.bos.xcache.server.store.data.hash.HashCache;

public class HMGetCommandHandler
extends AbstractCommandHandler<HMGetCommand> {
    @Override
    public CommandType type() {
        return CommandType.HMGET;
    }

    @Override
    public Result doHandle(CommandContext context, HMGetCommand command) {
        CacheObject cache = context.globalIndex().find(command.getKey());
        if (null == cache) {
            return Results.success().andReturnArray(command.getFields().stream().map(f -> Value.NULL).collect(Collectors.toList()));
        }
        if (!(cache instanceof HashCache)) {
            return Results.failed().andError(ErrorCode.COMMAND_INVOKE_ARG_WRONG_TYPE, new String[0]);
        }
        List<BufferString> r = ((HashCache)cache).getValue().get(command.getFields());
        return r == null ? Results.success().andReturnEmptyArray() : Results.success().andReturnArray(Values.buffers2List(r));
    }
}

