/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.handler;

import kd.bos.xcache.server.cmd.context.CommandContext;
import kd.bos.xcache.server.cmd.handler.AbstractCommandHandler;
import kd.bos.xcache.server.cmd.model.HStrlenCommand;
import kd.bos.xcache.server.exception.ErrorCode;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.protocol.Value;
import kd.bos.xcache.server.result.Results;
import kd.bos.xcache.server.result.model.Result;
import kd.bos.xcache.server.store.basic.BufferString;
import kd.bos.xcache.server.store.data.CacheObject;
import kd.bos.xcache.server.store.data.hash.HashCache;

public class HStrlenCommandHandler
extends AbstractCommandHandler<HStrlenCommand> {
    @Override
    public CommandType type() {
        return CommandType.HSTRLEN;
    }

    @Override
    public Result doHandle(CommandContext context, HStrlenCommand command) {
        CacheObject cache = context.globalIndex().find(command.getKey());
        if (null == cache) {
            return Results.success().andReturn(Value.LONG_ZERO);
        }
        if (!(cache instanceof HashCache)) {
            return Results.failed().andError(ErrorCode.COMMAND_INVOKE_ARG_WRONG_TYPE, new String[0]);
        }
        BufferString r = ((HashCache)cache).getValue().get(command.getField());
        return r == null ? Results.success().andReturn(Value.LONG_ZERO) : Results.success().andReturn(Value.newLong(r.length()));
    }
}

