/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.handler;

import com.codahale.metrics.Gauge;
import java.util.Map;
import java.util.Optional;
import kd.bos.xcache.server.cmd.context.CommandContext;
import kd.bos.xcache.server.cmd.handler.AbstractCommandHandler;
import kd.bos.xcache.server.cmd.model.InfoCommand;
import kd.bos.xcache.server.metric.GaugeSet;
import kd.bos.xcache.server.metric.MetricsCenter;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.protocol.Value;
import kd.bos.xcache.server.result.Results;
import kd.bos.xcache.server.result.model.Result;
import org.apache.commons.lang3.text.WordUtils;

public class InfoCommandHandler
extends AbstractCommandHandler<InfoCommand> {
    @Override
    public CommandType type() {
        return CommandType.INFO;
    }

    @Override
    public Result doHandle(CommandContext context, InfoCommand command) {
        Optional<String> section = command.getSection();
        if (section.isPresent()) {
            GaugeSet gaugeSet = MetricsCenter.get().metrics(section.get().toLowerCase());
            if (gaugeSet == null) {
                return Results.success().andReturnEmpty();
            }
            StringBuilder result = this.convert2String(section.get(), gaugeSet);
            return Results.success().andReturn(Value.newBytes(result.toString().getBytes()));
        }
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, GaugeSet> each : MetricsCenter.get().metrics().entrySet()) {
            if (result.length() > 0) {
                result.append("\n");
            }
            result.append((CharSequence)this.convert2String(each.getKey(), each.getValue()));
        }
        return Results.success().andReturn(Value.newBytes(result.toString().getBytes()));
    }

    private StringBuilder convert2String(String group, GaugeSet gaugeSet) {
        StringBuilder result = new StringBuilder();
        result.append(String.format("# %s\n", WordUtils.capitalize((String)group)));
        for (Map.Entry<String, Gauge> each : gaugeSet.gauges().entrySet()) {
            result.append(String.format("%s:%s\n", each.getKey(), each.getValue().getValue()));
        }
        return result;
    }
}

