/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.handler;

import kd.bos.xcache.server.cmd.context.CommandContext;
import kd.bos.xcache.server.cmd.handler.AbstractCommandHandler;
import kd.bos.xcache.server.cmd.model.LInsertCommand;
import kd.bos.xcache.server.exception.ErrorCode;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.protocol.Value;
import kd.bos.xcache.server.result.Results;
import kd.bos.xcache.server.result.model.Result;
import kd.bos.xcache.server.store.data.CacheObject;
import kd.bos.xcache.server.store.data.list.ListCache;
import kd.bos.xcache.server.store.data.list.ListData;

public class LInsertCommandHandler
extends AbstractCommandHandler<LInsertCommand> {
    @Override
    public CommandType type() {
        return CommandType.LINSERT;
    }

    @Override
    public Result doHandle(CommandContext context, LInsertCommand command) {
        CacheObject cache = context.globalIndex().find(command.getKey());
        if (null == cache) {
            return Results.success().andReturn(Value.LONG_ZERO);
        }
        if (!(cache instanceof ListCache)) {
            return Results.failed().andError(ErrorCode.COMMAND_INVOKE_ARG_WRONG_TYPE, new String[0]);
        }
        ListData listData = ((ListCache)cache).getValue();
        long oldMemory = listData.memSize();
        boolean foundPivot = command.isBefore() ? listData.insertBefore(command.getPivot(), command.getElement()) : listData.insertAfter(command.getPivot(), command.getElement());
        if (foundPivot) {
            long incrementMemory = (long)listData.memSize() - oldMemory;
            context.globalIndex().updateMemory(command.getKey(), incrementMemory);
            return Results.success().andReturn(Value.newLong(listData.size()));
        }
        return Results.success().andReturn(Value.newLong(-1L));
    }
}

