/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.handler;

import java.util.List;
import kd.bos.xcache.server.cmd.context.CommandContext;
import kd.bos.xcache.server.cmd.handler.AbstractCommandHandler;
import kd.bos.xcache.server.cmd.handler.Values;
import kd.bos.xcache.server.cmd.model.LRangeCommand;
import kd.bos.xcache.server.exception.ErrorCode;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.result.Results;
import kd.bos.xcache.server.result.model.Result;
import kd.bos.xcache.server.store.basic.BufferString;
import kd.bos.xcache.server.store.data.CacheObject;
import kd.bos.xcache.server.store.data.list.ListCache;
import kd.bos.xcache.server.store.data.list.ListData;

public class LRangeCommandHandler
extends AbstractCommandHandler<LRangeCommand> {
    @Override
    public CommandType type() {
        return CommandType.LRANGE;
    }

    @Override
    public Result doHandle(CommandContext context, LRangeCommand command) {
        CacheObject cache = context.globalIndex().find(command.getKey());
        if (null == cache) {
            return Results.success().andReturnEmptyArray();
        }
        if (!(cache instanceof ListCache)) {
            return Results.failed().andError(ErrorCode.COMMAND_INVOKE_ARG_WRONG_TYPE, new String[0]);
        }
        ListData listData = ((ListCache)cache).getValue();
        List<BufferString> elements = listData.range(command.getStart(), command.getStop());
        return Results.success().andReturnArray(Values.buffers2List(elements));
    }
}

