/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.handler;

import java.util.Optional;
import kd.bos.xcache.server.cmd.CommandCenter;
import kd.bos.xcache.server.cmd.context.CommandContext;
import kd.bos.xcache.server.cmd.handler.AbstractCommandHandler;
import kd.bos.xcache.server.cmd.model.ManCommand;
import kd.bos.xcache.server.cmd.parser.CommandMetadata;
import kd.bos.xcache.server.exception.ErrorCode;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.protocol.Value;
import kd.bos.xcache.server.result.Results;
import kd.bos.xcache.server.result.model.Result;

public class ManCommandHandler
extends AbstractCommandHandler<ManCommand> {
    private static final String COMMAND_MAN_FORMAT = "%s\nUsage\n    %s\nSummary\n    %s\n";
    private static final String SUB_COMMAND_USAGE = "%s subcommand [argument]";

    @Override
    public CommandType type() {
        return CommandType.MAN;
    }

    @Override
    public Result doHandle(CommandContext context, ManCommand command) {
        Optional<CommandType> commandType;
        if (!CommandType.hasSubCommand(command.getCommand())) {
            commandType = CommandType.findCommandType(command.getCommand());
        } else {
            if (!command.getSubCommand().isPresent()) {
                return Results.success().andReturn(Value.newString(ManCommandHandler.subCommandManual(command)));
            }
            commandType = CommandType.findCommandType(command.getCommand(), command.getSubCommand().get());
            if (!commandType.isPresent()) {
                return ManCommandHandler.unSupportedError(String.format("%s %s", command.getCommand(), command.getSubCommand().get()));
            }
        }
        if (!commandType.isPresent()) {
            return ManCommandHandler.unSupportedError(command.getCommand());
        }
        CommandMetadata metadata = CommandCenter.metadata(commandType.get());
        if (null == metadata) {
            return ManCommandHandler.unSupportedError(commandType.get().name());
        }
        return Results.success().andReturn(Value.newString(ManCommandHandler.generateManual(metadata)));
    }

    private static String subCommandManual(ManCommand command) {
        return String.format(SUB_COMMAND_USAGE, command.getCommand().trim().toUpperCase());
    }

    private static String generateManual(CommandMetadata metadata) {
        return String.format(COMMAND_MAN_FORMAT, metadata.getCommandType().commandName(), metadata.getUsage(), metadata.getCommandType().desc());
    }

    private static Result unSupportedError(String command) {
        return Results.failed().andError(ErrorCode.COMMAND_UNSUPPORTED_ERROR, command);
    }
}

