/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.handler;

import kd.bos.xcache.server.cmd.context.CommandContext;
import kd.bos.xcache.server.cmd.handler.AbstractCommandHandler;
import kd.bos.xcache.server.cmd.handler.Values;
import kd.bos.xcache.server.cmd.model.SMembersCommand;
import kd.bos.xcache.server.exception.ErrorCode;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.result.Results;
import kd.bos.xcache.server.result.model.Result;
import kd.bos.xcache.server.store.data.CacheObject;
import kd.bos.xcache.server.store.data.set.SetCache;
import kd.bos.xcache.server.store.data.set.SetData;

public class SMembersCommandHandler
extends AbstractCommandHandler<SMembersCommand> {
    @Override
    public CommandType type() {
        return CommandType.SMEMBERS;
    }

    @Override
    public Result doHandle(CommandContext context, SMembersCommand command) {
        CacheObject cache = context.globalIndex().find(command.getKey());
        if (null == cache) {
            return Results.success().andReturnEmptyArray();
        }
        if (!(cache instanceof SetCache)) {
            return Results.failed().andError(ErrorCode.COMMAND_INVOKE_ARG_WRONG_TYPE, new String[0]);
        }
        SetData setData = ((SetCache)cache).getValue();
        return Results.success().andReturnArray(Values.buffers2List(setData.values()));
    }
}

