/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.handler;

import kd.bos.xcache.server.cmd.context.CommandContext;
import kd.bos.xcache.server.cmd.handler.AbstractCommandHandler;
import kd.bos.xcache.server.cmd.handler.Values;
import kd.bos.xcache.server.cmd.model.SRemCommand;
import kd.bos.xcache.server.exception.ErrorCode;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.protocol.Value;
import kd.bos.xcache.server.result.Results;
import kd.bos.xcache.server.result.model.Result;
import kd.bos.xcache.server.store.data.CacheObject;
import kd.bos.xcache.server.store.data.set.SetCache;
import kd.bos.xcache.server.store.data.set.SetData;

public class SRemCommandHandler
extends AbstractCommandHandler<SRemCommand> {
    @Override
    public CommandType type() {
        return CommandType.SREM;
    }

    @Override
    public Result doHandle(CommandContext context, SRemCommand command) {
        CacheObject cache = context.globalIndex().find(command.getKey());
        if (null == cache) {
            return Results.success().andReturn(Values.LONG_EMPTY);
        }
        if (!(cache instanceof SetCache)) {
            return Results.failed().andError(ErrorCode.COMMAND_INVOKE_ARG_WRONG_TYPE, new String[0]);
        }
        SetData setData = ((SetCache)cache).getValue();
        long oldMemory = setData.memSize();
        long removedCount = setData.remove(command.getMembers());
        long incrementMemory = (long)setData.memSize() - oldMemory;
        if (setData.size() == 0L) {
            context.globalIndex().remove(command.getKey());
        } else {
            context.globalIndex().updateMemory(command.getKey(), incrementMemory);
        }
        return Results.success().andReturn(Value.newLong(removedCount));
    }
}

