/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.handler;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import java.util.function.Predicate;
import kd.bos.xcache.server.cmd.context.CommandContext;
import kd.bos.xcache.server.cmd.handler.CommandHandler;
import kd.bos.xcache.server.cmd.handler.Values;
import kd.bos.xcache.server.cmd.model.ScanCommand;
import kd.bos.xcache.server.exception.ErrorCode;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.protocol.Value;
import kd.bos.xcache.server.result.Results;
import kd.bos.xcache.server.result.model.Result;
import kd.bos.xcache.server.store.data.CacheObject;
import kd.bos.xcache.server.store.data.Key;
import kd.bos.xcache.server.store.index.GlobalIndex;
import kd.bos.xcache.server.util.GlobMatcher;
import kd.bos.xcache.server.util.Longs;
import kd.bos.xcache.server.util.Sizes;
import org.apache.commons.lang3.tuple.Pair;

public class ScanCommandHandler
implements CommandHandler<ScanCommand> {
    private static final int MAX_COUNT = 1000;
    private static final int DEFAULT_COUNT = 10;
    public static final Function<Pair<Key, CacheObject>, Value> PAIR_2_KEY_VALUE = v -> Values.KEY_2_VALUE.apply((Key)v.getKey());

    @Override
    public CommandType type() {
        return CommandType.SCAN;
    }

    @Override
    public Result handle(CommandContext context, ScanCommand command) {
        return ScanCommandHandler.doScan(context, command, PAIR_2_KEY_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Result doScan(CommandContext context, ScanCommand command, Function<Pair<Key, CacheObject>, Value> mapper) {
        long memoryUsage = 0L;
        if (command.getMemory().isPresent()) {
            try {
                memoryUsage = Sizes.parse(command.getMemory().get());
            }
            catch (IllegalArgumentException e) {
                return Results.failed().andError(ErrorCode.COMMAND_INVOKE_SCAN_MEMORY_USAGE_ARGS_INVALID, new String[0]);
            }
        }
        GlobalIndex[] globalIndices = context.allGlobalIndices();
        int partition = Math.abs(Longs.getHigh(command.getCursor()) % globalIndices.length);
        int cursor = Longs.getLow(command.getCursor());
        int count = command.getCount().isPresent() ? (int)Math.min(command.getCount().get(), 1000L) : 10;
        LinkedList<List<Pair<Key, CacheObject>>> result = new LinkedList<List<Pair<Key, CacheObject>>>();
        int i = partition;
        while (i < globalIndices.length) {
            Pair<Integer, List<Pair<Key, CacheObject>>> scanResult;
            GlobalIndex globalIndex = globalIndices[i];
            Lock lock = globalIndex.readLock();
            lock.lock();
            try {
                scanResult = globalIndex.scan(cursor, count);
                partition = i++;
                cursor = (Integer)scanResult.getKey();
                result.add((List<Pair<Key, CacheObject>>)scanResult.getValue());
            }
            finally {
                lock.unlock();
            }
            if ((count -= ((List)scanResult.getValue()).size()) <= 0 || cursor != 0) break;
        }
        if (cursor == 0) {
            partition = (partition + 1) % globalIndices.length;
        }
        long nextMergeCursor = Longs.merge(partition, cursor);
        List<Value> values = ScanCommandHandler.filterData(command, mapper, memoryUsage, result);
        return Results.success().andReturnArray(Arrays.asList(Value.newBytes(Longs.toStringBytes(nextMergeCursor)), Value.newList(values)));
    }

    private static List<Value> filterData(ScanCommand command, Function<Pair<Key, CacheObject>, Value> mapper, long memoryUsage, List<List<Pair<Key, CacheObject>>> result) {
        Predicate<Pair<Key, CacheObject>> patternFilter = ScanCommandHandler.createPatternFilter(command);
        Predicate<Pair<Key, CacheObject>> typeFilter = ScanCommandHandler.createTypeFilter(command);
        Predicate<Pair<Key, CacheObject>> memoryUsageFilter = ScanCommandHandler.createMemoryUsageFilter(memoryUsage);
        LinkedList<Value> values = new LinkedList<Value>();
        for (List<Pair<Key, CacheObject>> partitionResult : result) {
            for (Pair<Key, CacheObject> each : partitionResult) {
                if (memoryUsageFilter != null && !memoryUsageFilter.test(each) || typeFilter != null && !typeFilter.test(each) || patternFilter != null && !patternFilter.test(each)) continue;
                values.add(mapper.apply(each));
            }
        }
        return values;
    }

    private static Predicate<Pair<Key, CacheObject>> createPatternFilter(ScanCommand command) {
        if (command.getPattern().isPresent()) {
            GlobMatcher matcher = GlobMatcher.pattern(command.getPattern().get(), false);
            return v -> matcher.match(((Key)v.getKey()).toString());
        }
        return null;
    }

    private static Predicate<Pair<Key, CacheObject>> createTypeFilter(ScanCommand command) {
        if (command.getType().isPresent()) {
            String type = command.getType().get().toLowerCase();
            return v -> ((CacheObject)v.getValue()).type().equals(type);
        }
        return null;
    }

    private static Predicate<Pair<Key, CacheObject>> createMemoryUsageFilter(long usage) {
        if (usage != 0L) {
            if (usage > 0L) {
                return v -> (long)((Key)v.getKey()).memSize() + (long)((CacheObject)v.getValue()).memSize() >= usage;
            }
            return v -> (long)((Key)v.getKey()).memSize() + (long)((CacheObject)v.getValue()).memSize() <= -usage;
        }
        return null;
    }
}

