/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.handler;

import kd.bos.xcache.server.cmd.context.CommandContext;
import kd.bos.xcache.server.cmd.handler.AbstractCommandHandler;
import kd.bos.xcache.server.cmd.model.SetExCommand;
import kd.bos.xcache.server.config.ServerPlatform;
import kd.bos.xcache.server.exception.ErrorCode;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.result.Results;
import kd.bos.xcache.server.result.model.Result;
import kd.bos.xcache.server.store.data.CacheObject;
import kd.bos.xcache.server.store.data.DataFactory;

public class SetExCommandHandler
extends AbstractCommandHandler<SetExCommand> {
    @Override
    public CommandType type() {
        return CommandType.SETEX;
    }

    @Override
    public Result doHandle(CommandContext context, SetExCommand command) {
        if (command.getSeconds() <= 0L) {
            return Results.failed().andError(ErrorCode.COMMAND_INVOKE_INVALID_EXPIRE_TIME, this.type().commandName().toLowerCase());
        }
        CacheObject cache = DataFactory.newStringCache(command.getValue());
        long addTimeMillis = Math.min(command.getSeconds(), ServerPlatform.maxExpireTime()) * 1000L;
        context.globalIndex().putAndExpire(command.getKey(), cache, System.currentTimeMillis() + addTimeMillis);
        return Results.success().andReturnOperationOK();
    }
}

