/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.handler;

import kd.bos.xcache.server.cmd.context.CommandContext;
import kd.bos.xcache.server.cmd.handler.AbstractCommandHandler;
import kd.bos.xcache.server.cmd.model.StrlenCommand;
import kd.bos.xcache.server.exception.ErrorCode;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.protocol.Value;
import kd.bos.xcache.server.result.Results;
import kd.bos.xcache.server.result.model.Result;
import kd.bos.xcache.server.store.data.CacheObject;
import kd.bos.xcache.server.store.data.string.NumberCache;
import kd.bos.xcache.server.store.data.string.StringCache;
import kd.bos.xcache.server.store.index.GlobalIndex;

public class StrlenCommandHandler
extends AbstractCommandHandler<StrlenCommand> {
    @Override
    public CommandType type() {
        return CommandType.STRLEN;
    }

    @Override
    public Result doHandle(CommandContext context, StrlenCommand command) {
        GlobalIndex index = context.globalIndex();
        CacheObject cacheObject = index.find(command.getKey());
        if (null == cacheObject) {
            return Results.success().andReturn(Value.LONG_ZERO);
        }
        if (cacheObject instanceof NumberCache || cacheObject instanceof StringCache) {
            Value value = Value.newLong(cacheObject.length());
            return Results.success().andReturn(value);
        }
        return Results.failed().andError(ErrorCode.COMMAND_INVOKE_ARG_WRONG_TYPE, new String[0]);
    }
}

