/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.handler;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.xcache.server.protocol.Value;
import kd.bos.xcache.server.store.basic.BufferString;
import kd.bos.xcache.server.store.data.Key;

public class Values {
    public static final Value LONG_TRUE = Value.LONG_ONE;
    public static final Value LONG_FALSE = Value.LONG_ZERO;
    public static final Value LONG_EMPTY = Value.LONG_ZERO;
    public static final Function<Key, Value> KEY_2_VALUE = key -> key != null ? Value.newBytes(key.key().bytes()) : Value.NULL;
    public static final Function<BufferString, Value> BUFFER_2_VALUE = buffer -> buffer != null ? Value.newBuffer(buffer.buffer()) : Value.NULL;

    private Values() {
    }

    public static List<Value> keys2List(Collection<Key> fields) {
        return fields.stream().map(KEY_2_VALUE).collect(Collectors.toList());
    }

    public static List<Value> buffers2List(Collection<BufferString> values) {
        return values.stream().map(BUFFER_2_VALUE).collect(Collectors.toList());
    }
}

