/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.model;

import java.util.ArrayList;
import java.util.List;
import kd.bos.xcache.server.cmd.model.SingleKeyCommand;
import kd.bos.xcache.server.cmd.model.anntation.OrderParameter;
import kd.bos.xcache.server.cmd.model.param.FieldAndValue;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.store.data.Key;

public class HSetCommand
extends SingleKeyCommand {
    @OrderParameter(order=2)
    private List<FieldAndValue> fieldAndValueList;

    public HSetCommand() {
    }

    public HSetCommand(Key key, List<FieldAndValue> fieldAndValueList) {
        super(key);
        this.fieldAndValueList = fieldAndValueList;
    }

    @Override
    public CommandType type() {
        return CommandType.HSET;
    }

    public List<FieldAndValue> getFieldAndValueList() {
        return this.fieldAndValueList;
    }

    @Override
    public void retain() {
        super.retain();
        for (FieldAndValue each : this.fieldAndValueList) {
            each.retain();
        }
    }

    @Override
    public void release() {
        super.release();
        for (FieldAndValue each : this.fieldAndValueList) {
            each.release();
        }
    }

    @Override
    public List<Object> args() {
        ArrayList<Object> result = new ArrayList<Object>(1 + this.fieldAndValueList.size() * 2);
        result.add(this.key);
        for (FieldAndValue fieldAndValue : this.fieldAndValueList) {
            result.add(fieldAndValue.getField());
            result.add(fieldAndValue.getValue());
        }
        return result;
    }
}

