/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.model;

import java.util.ArrayList;
import java.util.List;
import kd.bos.xcache.server.cmd.model.SingleKeyCommand;
import kd.bos.xcache.server.cmd.model.anntation.OrderParameter;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.store.basic.BufferString;
import kd.bos.xcache.server.store.data.Key;

public class RPushCommand
extends SingleKeyCommand {
    @OrderParameter(order=2, displayName="element")
    private List<BufferString> elements;

    public List<BufferString> getElements() {
        return this.elements;
    }

    public RPushCommand() {
    }

    public RPushCommand(Key key, List<BufferString> elements) {
        super(key);
        this.elements = elements;
    }

    @Override
    public CommandType type() {
        return CommandType.RPUSH;
    }

    @Override
    public void retain() {
        super.retain();
        for (BufferString each : this.elements) {
            each.retain();
        }
    }

    @Override
    public void release() {
        super.release();
        for (BufferString each : this.elements) {
            each.release();
        }
    }

    @Override
    public List<Object> args() {
        ArrayList<Object> result = new ArrayList<Object>(1 + this.elements.size());
        result.add(this.key);
        result.addAll(this.elements);
        return result;
    }
}

