/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.parser;

import javax.annotation.Nullable;
import kd.bos.xcache.server.cmd.model.anntation.BooleanSelector;

public class BoolParamMetadata {
    private final String trueValue;
    private final String falseValue;

    public static BoolParamMetadata create(BooleanSelector booleanSelector) {
        return new BoolParamMetadata(booleanSelector.trueValue().toUpperCase(), booleanSelector.falseValue().toUpperCase());
    }

    private BoolParamMetadata(String trueValue, String falseValue) {
        this.trueValue = trueValue;
        this.falseValue = falseValue;
    }

    @Nullable
    public Boolean parseValue(String value) {
        if (value == null) {
            return null;
        }
        String upperValue = value.toUpperCase();
        if (upperValue.equals(this.trueValue)) {
            return true;
        }
        if (upperValue.equals(this.falseValue)) {
            return false;
        }
        return null;
    }

    public String usage() {
        return String.format("%s|%s", this.trueValue, this.falseValue);
    }
}

