/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.parser;

import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.xcache.server.cmd.model.Command;
import kd.bos.xcache.server.cmd.parser.CompParamMetadata;
import kd.bos.xcache.server.cmd.parser.OptionParameterMetadata;
import kd.bos.xcache.server.cmd.parser.OrderParameterMetadata;
import kd.bos.xcache.server.cmd.parser.ParameterType;
import kd.bos.xcache.server.protocol.CommandType;

public class CommandMetadata<T extends Command>
extends CompParamMetadata<T> {
    private String usage;
    private CommandType commandType;
    private int arity;

    public CommandMetadata(CommandType commandType, Class<T> commandClass, List<OrderParameterMetadata> orderParameters, LinkedHashMap<String, OptionParameterMetadata> optionParameters) {
        super(commandClass, orderParameters, optionParameters);
        this.commandType = commandType;
        this.usage = String.format("%s%s", new Object[]{commandType, this.parameterUsage()});
        this.arity = this.calculateArity(orderParameters, optionParameters);
    }

    public String getUsage() {
        return this.usage;
    }

    public CommandType getCommandType() {
        return this.commandType;
    }

    public int getArity() {
        return this.arity;
    }

    private int calculateArity(List<OrderParameterMetadata> orderParameters, LinkedHashMap<String, OptionParameterMetadata> optionParameters) {
        boolean isParameterCountAtLeastMode = !optionParameters.isEmpty() || this.isParameterCountAtLeastMode(orderParameters);
        int paramCount = this.calculateParamsArity(orderParameters) + 1;
        return isParameterCountAtLeastMode ? -paramCount : paramCount;
    }

    private boolean isParameterCountAtLeastMode(List<OrderParameterMetadata> parameters) {
        for (OrderParameterMetadata each : parameters) {
            if (!this.isParameterCountAtLeastMode(each)) continue;
            return true;
        }
        return false;
    }

    private boolean isParameterCountAtLeastMode(OrderParameterMetadata orderParameterMetadata) {
        if (orderParameterMetadata.isOptional() || orderParameterMetadata.isList()) {
            return true;
        }
        if (ParameterType.COMPOSITE == orderParameterMetadata.getValueType()) {
            return this.isParameterCountAtLeastMode(orderParameterMetadata.getCompParamMetadata().getOrderParameters());
        }
        return false;
    }

    private int calculateParamsArity(OrderParameterMetadata orderParameterMetadata) {
        if (ParameterType.COMPOSITE == orderParameterMetadata.getValueType()) {
            return this.calculateParamsArity(orderParameterMetadata.getCompParamMetadata().getOrderParameters());
        }
        return orderParameterMetadata.isOptional() ? 0 : 1;
    }

    private int calculateParamsArity(List<OrderParameterMetadata> parameters) {
        return parameters.stream().mapToInt(this::calculateParamsArity).sum();
    }
}

