/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.xcache.server.cmd.model.Command;
import kd.bos.xcache.server.cmd.parser.CommandMetadata;
import kd.bos.xcache.server.cmd.parser.CompParamMetadata;
import kd.bos.xcache.server.cmd.parser.OptionParameterMetadata;
import kd.bos.xcache.server.cmd.parser.OrderParameterMetadata;
import kd.bos.xcache.server.cmd.parser.ParameterMetadata;
import kd.bos.xcache.server.cmd.parser.ParameterType;
import kd.bos.xcache.server.cmd.parser.ValueConvertors;
import kd.bos.xcache.server.exception.CommandInvalidException;
import kd.bos.xcache.server.exception.CommandLongArgFormatException;
import kd.bos.xcache.server.exception.CommandSyntaxErrorException;
import kd.bos.xcache.server.exception.CommandWrongArgNumException;
import kd.bos.xcache.server.exception.UnsupportedCommandException;
import kd.bos.xcache.server.protocol.CommandType;
import kd.bos.xcache.server.protocol.Request;
import kd.bos.xcache.server.protocol.Value;
import kd.bos.xcache.server.store.data.Key;
import kd.bos.xcache.server.util.ByteBufUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandParser {
    private static final Logger log = LoggerFactory.getLogger(CommandParser.class);
    private final Map<CommandType, CommandMetadata> metadataMap;

    public CommandParser(Map<CommandType, CommandMetadata> metadataMap) {
        this.metadataMap = metadataMap;
    }

    public Command parse(Request request) throws CommandInvalidException {
        try {
            CommandMetadata commandMetadata = this.metadataMap.get((Object)request.getCommand());
            if (null == commandMetadata) {
                throw new UnsupportedCommandException(request.getCommand().name());
            }
            return new RealParser(commandMetadata, request.getArgs()).parse();
        }
        catch (ReflectiveOperationException e) {
            log.warn(String.format("Error occurred when parse command %s", request.getCommand().name()), (Throwable)e);
            throw new UnsupportedCommandException(request.getCommand().name(), (Throwable)e);
        }
    }

    static class RealParser<T extends Command> {
        private final CommandMetadata<T> commandMetadata;
        private final List<Value<?>> args;
        private final int argSize;
        private int argIndex = 0;

        public RealParser(CommandMetadata<T> commandMetadata, List<Value<?>> args) {
            this.commandMetadata = commandMetadata;
            this.args = args instanceof ArrayList ? args : new ArrayList(args);
            this.argSize = args.size();
        }

        public Command parse() throws CommandInvalidException, ReflectiveOperationException {
            this.checkArgsCount();
            return (Command)this.doParse(this.commandMetadata, true);
        }

        private void checkArgsCount() throws CommandWrongArgNumException {
            if (this.commandMetadata.getArity() >= 0 && this.argSize != this.commandMetadata.getArity() - 1 || this.commandMetadata.getArity() < 0 && this.argSize < -(this.commandMetadata.getArity() + 1)) {
                throw this.wrongNumberArgs();
            }
        }

        private <V> V doParse(CompParamMetadata<V> compParamMetadata, boolean isFirstLevel) throws ReflectiveOperationException, CommandInvalidException {
            V target = compParamMetadata.getParameterClass().newInstance();
            ListIterator<OrderParameterMetadata> pIterator = compParamMetadata.getOrderParameters().listIterator();
            while (this.hasArgs() && pIterator.hasNext()) {
                this.parseAndFillingFields(pIterator, target);
            }
            LinkedHashMap<String, OptionParameterMetadata> optionParameters = compParamMetadata.getOptionParameters();
            HashSet<String> parsedOptions = new HashSet<String>();
            while (this.hasArgs()) {
                if (this.commandMetadata.getMaxOptionLen() > 0) {
                    this.tryToParseOptionParameter(optionParameters, target, parsedOptions);
                    continue;
                }
                if (!isFirstLevel) break;
                throw this.wrongNumberArgs();
            }
            while (pIterator.hasNext()) {
                OrderParameterMetadata orderParameterMetadata = (OrderParameterMetadata)pIterator.next();
                if (orderParameterMetadata.isOptional()) {
                    this.setParameterValue(orderParameterMetadata, target, Optional.empty());
                    continue;
                }
                throw this.wrongNumberArgs();
            }
            if (parsedOptions.size() < optionParameters.size()) {
                for (Map.Entry<String, OptionParameterMetadata> each : optionParameters.entrySet()) {
                    if (parsedOptions.contains(each.getKey())) continue;
                    this.setParameterValue(each.getValue(), target, Optional.empty());
                }
            }
            return target;
        }

        private <V> void tryToParseOptionParameter(LinkedHashMap<String, OptionParameterMetadata> optionParameters, V target, Set<String> parsedOptions) throws CommandInvalidException {
            OptionParameterMetadata optionParameterMetadata;
            if (this.args.get(this.argIndex).getBuffer().readableBytes() > this.commandMetadata.getMaxOptionLen()) {
                throw this.syntaxError();
            }
            String option = this.peekOption(this.args.get(this.argIndex));
            if (option != null) {
                option = option.toUpperCase();
            }
            if ((optionParameterMetadata = optionParameters.get(option)) == null) {
                throw this.syntaxError();
            }
            this.skipOneArgs();
            if (!this.hasArgs()) {
                throw this.wrongNumberArgs();
            }
            this.parseAndFillingField(optionParameterMetadata, target);
            parsedOptions.add(optionParameterMetadata.getOption());
        }

        private void skipOneArgs() {
            this.args.get(this.argIndex++).getBuffer().release();
        }

        private <V> void parseAndFillingField(OptionParameterMetadata optionParameterMetadata, V target) throws CommandInvalidException {
            Object value = this.parseSingleOptionParameter(this.args.get(this.argIndex++), optionParameterMetadata);
            this.setParameterValue(optionParameterMetadata, target, value);
        }

        private String peekOption(Value<?> value) {
            return ByteBufUtil.subString(value.getBuffer(), value.getBuffer().readableBytes());
        }

        private Object parseSingleOptionParameter(Value<?> each, OptionParameterMetadata optionParameterMetadata) throws CommandInvalidException {
            Object value;
            ParameterType parameterType = optionParameterMetadata.getValueType();
            if (ParameterType.LONG == parameterType) {
                try {
                    value = ValueConvertors.LONG_CONVERTOR.apply(each);
                }
                catch (NumberFormatException e) {
                    throw new CommandLongArgFormatException(optionParameterMetadata.getDisplayName(), this.commandMetadata.getUsage(), e);
                }
            } else if (ParameterType.STRING == parameterType) {
                value = ValueConvertors.STRING_CONVERTOR.apply(each);
            } else {
                if (log.isWarnEnabled()) {
                    log.warn(String.format("Unsupported parameter type %s of %s for option parameter", new Object[]{parameterType, this.commandMetadata.getParameterClass()}));
                }
                throw new UnsupportedCommandException(this.commandMetadata.getCommandType().commandName());
            }
            return Optional.of(value);
        }

        private void parseAndFillingFields(Iterator<OrderParameterMetadata> pIterator, Object target) throws CommandInvalidException, ReflectiveOperationException {
            while (this.hasArgs() && pIterator.hasNext()) {
                ArrayList<Object> value;
                OrderParameterMetadata orderParameterMetadata = pIterator.next();
                if (orderParameterMetadata.isList()) {
                    ArrayList<Object> list = new ArrayList<Object>(this.argSize - this.argIndex);
                    while (this.hasArgs()) {
                        list.add(this.parseOneParameter(orderParameterMetadata));
                    }
                    value = list;
                } else {
                    value = this.parseOneParameter(orderParameterMetadata);
                }
                if (value == null) {
                    throw this.syntaxError();
                }
                this.setParameterValue(orderParameterMetadata, target, value);
            }
        }

        private boolean hasArgs() {
            return this.argIndex < this.argSize;
        }

        private Object parseOneParameter(OrderParameterMetadata orderParameterMetadata) throws ReflectiveOperationException, CommandInvalidException {
            ParameterType parameterType = orderParameterMetadata.getValueType();
            if (ParameterType.COMPOSITE == parameterType) {
                return this.doParse(orderParameterMetadata.getCompParamMetadata(), false);
            }
            return this.parseSingleParameter(this.args.get(this.argIndex++), orderParameterMetadata);
        }

        private Object parseSingleParameter(Value<?> each, OrderParameterMetadata orderParameterMetadata) throws CommandInvalidException {
            Object value;
            ParameterType parameterType = orderParameterMetadata.getValueType();
            if (ParameterType.KEY == parameterType) {
                value = Key.of(ValueConvertors.BINARY_STRING_CONVERTOR.apply(each));
            } else if (ParameterType.LONG == parameterType) {
                try {
                    value = ValueConvertors.LONG_CONVERTOR.apply(each);
                }
                catch (NumberFormatException e) {
                    throw new CommandLongArgFormatException(orderParameterMetadata.getDisplayName(), this.commandMetadata.getUsage(), e);
                }
            } else if (ParameterType.BUFFER_STRING == parameterType) {
                value = ValueConvertors.BUFFER_STRING_CONVERTOR.apply(each);
            } else if (ParameterType.STRING == parameterType) {
                value = ValueConvertors.BINARY_STRING_CONVERTOR.apply(each).toString();
            } else if (ParameterType.BOOLEAN == parameterType) {
                String strValue = ValueConvertors.STRING_CONVERTOR.apply(each);
                value = orderParameterMetadata.getBoolParamMetadata().parseValue(strValue);
            } else {
                if (log.isWarnEnabled()) {
                    log.warn(String.format("Unsupported parameter type %s of %s", new Object[]{parameterType, this.commandMetadata.getParameterClass()}));
                }
                throw new UnsupportedCommandException(this.commandMetadata.getCommandType().commandName());
            }
            if (orderParameterMetadata.isOptional()) {
                value = Optional.of(value);
            }
            return value;
        }

        private CommandWrongArgNumException wrongNumberArgs() {
            return new CommandWrongArgNumException(this.commandMetadata.getCommandType().commandName(), this.commandMetadata.getUsage());
        }

        private CommandSyntaxErrorException syntaxError() {
            return new CommandSyntaxErrorException(this.commandMetadata.getCommandType().commandName(), this.commandMetadata.getUsage());
        }

        private void setParameterValue(ParameterMetadata parameterMetadata, Object target, Object value) {
            parameterMetadata.getField().setAccessible(true);
            try {
                parameterMetadata.getField().set(target, value);
            }
            catch (IllegalAccessException e) {
                log.error(String.format("Error occurred when access %s of %s", parameterMetadata.getFieldName(), target.getClass()), (Throwable)e);
                throw new UnsupportedCommandException(this.commandMetadata.getCommandType().name(), (Throwable)e);
            }
        }
    }
}

