/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.cmd.parser;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Function;
import kd.bos.xcache.server.exception.InvalidArgumentException;
import kd.bos.xcache.server.protocol.Value;
import kd.bos.xcache.server.protocol.ValueType;
import kd.bos.xcache.server.store.basic.BinaryString;
import kd.bos.xcache.server.store.basic.BufferString;
import kd.bos.xcache.server.util.ByteBufUtil;
import kd.bos.xcache.server.util.Longs;

public class ValueConvertors {
    public static final Function<Value, BinaryString> BINARY_STRING_CONVERTOR = value -> {
        if (null == value) {
            return null;
        }
        if (value.getType() == ValueType.BUFFER) {
            ByteBuf buffer = value.getBuffer();
            byte[] data = new byte[buffer.readableBytes()];
            buffer.readBytes(data);
            ByteBufUtil.release(buffer);
            return BinaryString.wrap(data);
        }
        throw ValueConvertors.invalidValueTypeException(value);
    };
    public static final Function<Value, Long> LONG_CONVERTOR = value -> {
        if (null == value) {
            throw new NumberFormatException();
        }
        if (value.getType() == ValueType.BUFFER) {
            ByteBuf buffer = value.getBuffer();
            Optional<Long> result = Longs.parseLong(buffer);
            ByteBufUtil.release(buffer);
            return result.orElseThrow(NumberFormatException::new);
        }
        throw ValueConvertors.invalidValueTypeException(value);
    };
    public static final Function<Value, String> STRING_CONVERTOR = value -> {
        if (null == value) {
            return null;
        }
        if (value.getType() == ValueType.BUFFER) {
            ByteBuf buffer = value.getBuffer();
            byte[] data = new byte[buffer.readableBytes()];
            buffer.readBytes(data);
            ByteBufUtil.release(buffer);
            return new String(data, StandardCharsets.UTF_8);
        }
        throw ValueConvertors.invalidValueTypeException(value);
    };
    public static final Function<Value, BufferString> BUFFER_STRING_CONVERTOR = value -> {
        if (null == value) {
            return null;
        }
        if (value.getType() == ValueType.BUFFER) {
            return BufferString.wrap(value.getBuffer());
        }
        throw ValueConvertors.invalidValueTypeException(value);
    };

    private ValueConvertors() {
    }

    private static InvalidArgumentException invalidValueTypeException(Value value) {
        return new InvalidArgumentException(String.format("Illegal value type %s", new Object[]{value.getType()}));
    }
}

