/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerPlatform {
    private static String propertiesFileContent;
    private static final Logger log;
    private static final long DEFAULT_DEFAULT_EXPIRE_SECONDS;
    private static final long DEFAULT_MAX_EXPIRE_SECONDS;
    private static final int DEFAULT_SERVER_PORT = 6380;
    private static final int DEFAULT_MAX_CONNECTIONS = 10000;
    private static final int DEFAULT_MAX_CONNECTION_READ_IDLE_SECONDS = 0;
    private static final int DEFAULT_PARTITION_SIZE;
    private static final int DEFAULT_TASK_EXECUTOR_QUEUE_SIZE = 100000;
    private static final int DEFAULT_TASK_EXECUTOR_SHUTDOWN_TIMEOUT_MILLIS = 100;
    private static final int DEFAULT_ALLOCATOR_CAPACITY_PERCENT = 85;
    public static final long FIXED_USAGE_MEMORY = 0x4000000L;
    public static final long PER_MEMORY_EACH_PROCESSOR = 0x1000000L;
    public static final long DEFAULT_SLOWLOG_LOG_SLOWER_THAN_MICROSECONDS = 10000L;
    public static final int DEFAULT_SLOWLOG_MAX_LEN = 1024;
    private static final Map<String, String> propertiesConfiguration;
    private static final Map<String, Object> systemConfiguration;
    private static final Map<String, Object> customConfiguration;
    private static volatile long overheadMemory;

    private ServerPlatform() {
    }

    private static void initConfigurationFromSystemProperties() {
        systemConfiguration.clear();
        ServerPlatform.initSystemConfiguration("xcache.server_port", 6380);
        ServerPlatform.initSystemConfiguration("xcache.max_connections", 10000);
        ServerPlatform.initSystemConfiguration("xcache.default_expire_seconds", DEFAULT_DEFAULT_EXPIRE_SECONDS);
        ServerPlatform.initSystemConfiguration("xcache.max_expire_seconds", DEFAULT_MAX_EXPIRE_SECONDS);
        ServerPlatform.initSystemConfiguration("xcache.max_connection_read_idle_seconds", 0);
        ServerPlatform.initSystemConfiguration("io.netty.availableProcessors", Runtime.getRuntime().availableProcessors());
        ServerPlatform.initSystemConfiguration("xcache.partition_size", DEFAULT_PARTITION_SIZE);
        ServerPlatform.initSystemConfiguration("xcache.dispatch_with_extra_thread", false);
        ServerPlatform.initSystemConfiguration("xcache.server_test_mode", false);
        ServerPlatform.initSystemConfiguration("xcache.allocator_capacity_percent", 85);
        ServerPlatform.initSystemConfiguration("xcache.slowlog_log_slower_than_microseconds", 10000L);
        ServerPlatform.initSystemConfiguration("xcache.slowlog_max_len", 1024);
        ServerPlatform.initRootPassword();
        ServerPlatform.initOverheadMemory();
    }

    private static void initOverheadMemory() {
        overheadMemory = 0x4000000L + (long)ServerPlatform.availableProcessors() * 0x1000000L;
    }

    private static void initSystemConfiguration(String name, int defaultValue) {
        ServerPlatform.initSystemConfiguration(name, defaultValue, Integer::parseInt);
    }

    private static <T> void initSystemConfiguration(String name, T defaultValue, Function<String, T> function) {
        ServerPlatform.initSystemConfiguration(name, defaultValue, function, true);
    }

    private static <T> void initSystemConfiguration(String name, T defaultValue, Function<String, T> function, boolean logValue) {
        String value = System.getProperty(name);
        if (StringUtils.isBlank((CharSequence)value)) {
            value = propertiesConfiguration.get(name);
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            systemConfiguration.put(name, defaultValue);
        } else {
            systemConfiguration.put(name, function.apply(value));
        }
        if (logValue) {
            ServerPlatform.logValue(name);
        }
    }

    private static void logValue(String name) {
        if (log.isInfoEnabled()) {
            log.info(String.format("Init Configuration: %s=%s", name, systemConfiguration.get(name)));
        }
    }

    private static void initSystemConfiguration(String name, long defaultValue) {
        ServerPlatform.initSystemConfiguration(name, defaultValue, Long::parseLong);
    }

    private static void initSystemConfiguration(String name, boolean defaultValue) {
        ServerPlatform.initSystemConfiguration(name, defaultValue, Boolean::parseBoolean);
    }

    private static void initRootPassword() {
        ServerPlatform.initSystemConfiguration("xcache.password", new byte[0], String::getBytes, false);
        if (log.isInfoEnabled()) {
            log.info(String.format("Password auth %s", ServerPlatform.getRootPassword().length > 0 ? "enabled" : "not enabled"));
        }
    }

    public static byte[] getRootPassword() {
        return (byte[])ServerPlatform.get("xcache.password");
    }

    public static boolean isServerTestMode() {
        return (Boolean)ServerPlatform.get("xcache.server_test_mode");
    }

    public static int availableProcessors() {
        return (Integer)ServerPlatform.get("io.netty.availableProcessors");
    }

    public static long overheadMemory() {
        return overheadMemory;
    }

    public static int maxConnection() {
        return (Integer)ServerPlatform.get("xcache.max_connections");
    }

    public static int maxReadIdleSeconds() {
        return (Integer)ServerPlatform.get("xcache.max_connection_read_idle_seconds");
    }

    public static int partitionSize() {
        return (Integer)ServerPlatform.get("xcache.partition_size");
    }

    public static int serverPort() {
        return (Integer)ServerPlatform.get("xcache.server_port");
    }

    public static int allocatorCapacityPercent() {
        return (Integer)ServerPlatform.get("xcache.allocator_capacity_percent");
    }

    public static long defaultExpireTime() {
        return (Long)ServerPlatform.get("xcache.default_expire_seconds");
    }

    public static long maxExpireTime() {
        return (Long)ServerPlatform.get("xcache.max_expire_seconds");
    }

    public static boolean isDispatchWithExtraThread() {
        return (Boolean)ServerPlatform.get("xcache.dispatch_with_extra_thread");
    }

    public static int taskExecutorThreadCount() {
        return ServerPlatform.availableProcessors() * 2;
    }

    public static int taskExecutorQueueCount() {
        return 100000;
    }

    public static long taskExecutorShutdownTimeoutMillis() {
        return 100L;
    }

    public static long slowlogLogSlowerThanMicroseconds() {
        return (Long)ServerPlatform.get("xcache.slowlog_log_slower_than_microseconds");
    }

    public static int slowlogMaxLen() {
        return (Integer)ServerPlatform.get("xcache.slowlog_max_len");
    }

    public static void init() {
        ServerPlatform.initConfigurationFromPropertiesFileContent();
        ServerPlatform.initConfigurationFromSystemProperties();
    }

    private static void initConfigurationFromPropertiesFileContent() {
        propertiesConfiguration.clear();
        String config = System.getProperty("xcache.config");
        if (StringUtils.isBlank((CharSequence)config)) {
            config = propertiesFileContent;
        }
        if (StringUtils.isBlank((CharSequence)config)) {
            return;
        }
        Properties properties = new Properties();
        try {
            properties.load(new ByteArrayInputStream(config.getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (String name : properties.stringPropertyNames()) {
            propertiesConfiguration.put(String.format("%s%s", "xcache.", name), properties.getProperty(name));
        }
    }

    private static Object get(String name) {
        Object result = customConfiguration.get(name);
        return result != null ? result : systemConfiguration.get(name);
    }

    public static void setPropertiesFileContent(String config) {
        propertiesFileContent = config;
    }

    public static Object setConfiguration(String key, Object value) {
        return customConfiguration.put(key, value);
    }

    public static Object clearConfiguration(String key) {
        return customConfiguration.remove(key);
    }

    static {
        log = LoggerFactory.getLogger(ServerPlatform.class);
        DEFAULT_DEFAULT_EXPIRE_SECONDS = TimeUnit.HOURS.toSeconds(1L);
        DEFAULT_MAX_EXPIRE_SECONDS = TimeUnit.DAYS.toSeconds(365L);
        DEFAULT_PARTITION_SIZE = (int)Math.min(Math.max(1L, Runtime.getRuntime().maxMemory() / 0x10000000L), 1024L);
        propertiesConfiguration = new ConcurrentHashMap<String, String>();
        systemConfiguration = new ConcurrentHashMap<String, Object>();
        customConfiguration = new ConcurrentHashMap<String, Object>();
    }
}

