/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.exception;

public enum ErrorCode {
    SUCCESS(0, "success with no error."),
    ERROR(1, "Unexpected error: %s"),
    ARGUMENT_NOT_VALID(1101, "Argument not valid: %s"),
    COMMAND_INVOKE_ERROR(1200, "Error occurred when invoke command: %s"),
    COMMAND_INVOKE_INTERRUPTED_ERROR(1201, "Interrupted occurred when invoke command"),
    COMMAND_INVOKE_ARG_WRONG_TYPE(1202, "WRONGTYPE Operation against a key holding the wrong kind of value"),
    COMMAND_INVOKE_INCREMENT_OVERFLOW(1203, "Increment or decrement would overflow"),
    COMMAND_INVOKE_INCREMENT_STRING(1204, "Value is not an 64-bit signed integer or out of range"),
    COMMAND_INVOKE_INDEX_OUT_OF_RANGE(1205, "ERR index out of range: %s"),
    COMMAND_INVOKE_KEY_NOT_EXISTS(1206, "ERR no such key"),
    COMMAND_INVOKE_INVALID_EXPIRE_TIME(1207, "ERR invalid expire time in %s"),
    COMMAND_INVOKE_INTEGER_SHOULD_NEGATIVE_OR_ZERO(1208, "Value [%s] needs to be an integer greater than or equal to zero"),
    COMMAND_INVOKE_SCAN_MEMORY_USAGE_ARGS_INVALID(1209, "Illegal memory usage format, should like 968, 100K or 1.2M"),
    COMMAND_INVALID_ERROR(1300, "Command invalid: %s"),
    COMMAND_UNSUPPORTED_ERROR(1301, "Unsupported command: %s"),
    AUTH_REQUIRED(1401, "NOAUTH Authentication required"),
    AUTH_PASSWORD_ERROR(1402, "Invalid password"),
    AUTH_NO_NEED(1403, "Authentication is not required, perhaps you could check your configuration"),
    TOO_MANY_CONNECTIONS(1501, "Too many connections, please try again later"),
    NET_PROTOCOL_ERROR(1600, "Protocol error: %s"),
    RESULT_CONVERT_FAILED(1701, "Result convert failed: %s");

    private final Integer code;
    private final String desc;

    private ErrorCode(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String format(Object ... messageArgs) {
        return String.format(this.getDesc(), messageArgs);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

