/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.executor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kd.bos.xcache.server.common.ThreadFactories;
import kd.bos.xcache.server.config.ServerPlatform;
import kd.bos.xcache.server.exception.UnExceptedException;
import kd.bos.xcache.server.executor.Task;
import kd.bos.xcache.server.executor.TaskExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolTaskExecutor
implements TaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolTaskExecutor.class);
    private static final String THREAD_NAME_PREFIX = "Task-Executor-";
    private volatile boolean isStarted;
    private final long maxWaitMillForShutdown;
    private ExecutorService executorService;
    private final int threadCounts;
    private final int queueSize;

    public ThreadPoolTaskExecutor() {
        this(ServerPlatform.taskExecutorThreadCount(), ServerPlatform.taskExecutorQueueCount(), ServerPlatform.taskExecutorShutdownTimeoutMillis());
    }

    ThreadPoolTaskExecutor(int threadCounts, int queueSize, long maxWaitMillForShutdown) {
        this.maxWaitMillForShutdown = maxWaitMillForShutdown;
        this.threadCounts = threadCounts;
        this.queueSize = queueSize;
    }

    private void initExecutorService() {
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(this.queueSize);
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        this.executorService = new ThreadPoolExecutor(this.threadCounts, this.threadCounts, 0L, TimeUnit.MILLISECONDS, queue, ThreadFactories.get().newNamedDaemon(THREAD_NAME_PREFIX));
    }

    @Override
    public synchronized void start() {
        if (this.isStarted) {
            return;
        }
        this.initExecutorService();
        this.isStarted = true;
    }

    @Override
    public synchronized void shutdown() {
        if (!this.isStarted) {
            return;
        }
        this.executorService.shutdown();
        try {
            boolean isTermination = this.executorService.awaitTermination(this.maxWaitMillForShutdown, TimeUnit.MILLISECONDS);
            if (!isTermination) {
                if (log.isInfoEnabled()) {
                    log.info(String.format("Shutdown directly after wait %s milliseconds", this.maxWaitMillForShutdown));
                }
                this.executorService.shutdownNow();
            }
            this.isStarted = false;
        }
        catch (InterruptedException e) {
            this.executorService.shutdownNow();
            this.isStarted = false;
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void submit(Task task) {
        if (!this.isStarted) {
            throw new UnExceptedException("Executor has not been started or has been terminated");
        }
        this.executorService.submit(task);
    }
}

