/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.mem;

import io.netty.buffer.XCacheMemoryLimiter;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import kd.bos.xcache.server.metric.DefaultGaugeSet;
import kd.bos.xcache.server.util.Sizes;

public class AllocatorMemoryMetrics
extends DefaultGaugeSet {
    private final LongAdder outOfMemory = new LongAdder();
    private final AtomicLong lastUpdate = new AtomicLong();

    public AllocatorMemoryMetrics(XCacheMemoryLimiter limiter) {
        super("memory");
        this.gauges.put("allocator_max_memory", limiter::limit);
        this.gauges.put("allocator_max_memory_human", () -> Sizes.format(limiter.limit()));
        this.gauges.put("allocator_used_memory", limiter::used);
        this.gauges.put("allocator_used_memory_human", () -> Sizes.format(limiter.used()));
        this.gauges.put("allocator_out_of_memory", this.outOfMemory::sum);
        this.gauges.put("allocator_out_of_memory_last_millis", this.lastUpdate::get);
    }

    public void incrementOutOfMemoryCount() {
        this.outOfMemory.increment();
        this.lastUpdate.set(System.currentTimeMillis());
    }
}

