/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.mem;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.XCacheHeapPoolArena;
import io.netty.buffer.XCacheMemoryLimiter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import kd.bos.xcache.server.cmd.model.ResetMemoryCommand;
import kd.bos.xcache.server.exception.CommandInvokeException;
import kd.bos.xcache.server.exception.UnExceptedException;
import kd.bos.xcache.server.invoker.CommandInvokers;
import kd.bos.xcache.server.mem.AllocatorMemoryMetrics;
import kd.bos.xcache.server.mem.AllocatorMemoryStats;
import kd.bos.xcache.server.mem.DefaultXCacheMemoryLimiter;
import kd.bos.xcache.server.metric.MetricsCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteBufAllocatorProxy
extends PooledByteBufAllocator
implements AllocatorMemoryStats {
    private static final Logger log = LoggerFactory.getLogger(ByteBufAllocatorProxy.class);
    static final int DEFAULT_INITIAL_CAPACITY = 256;
    static final int DEFAULT_MAX_CAPACITY = Integer.MAX_VALUE;
    private static final int EACH_STEP_PERCENT = 25;
    private static final int LOWEST_PERCENT = 20;
    private static final int FIRST_TIME = 0;
    private final CommandInvokers commandInvokers;
    private final XCacheMemoryLimiter limiter;
    private final AllocatorMemoryMetrics metrics;

    public ByteBufAllocatorProxy(long capacity, CommandInvokers commandInvokers) {
        super(false, ByteBufAllocatorProxy.defaultNumHeapArena(), 0, PooledByteBufAllocator.defaultPageSize(), PooledByteBufAllocator.defaultMaxOrder());
        this.commandInvokers = commandInvokers;
        this.limiter = new DefaultXCacheMemoryLimiter(capacity);
        this.metrics = new AllocatorMemoryMetrics(this.limiter);
        MetricsCenter.get().register(this.metrics);
        try {
            this.resetHeapArenas(this.limiter);
        }
        catch (Exception e) {
            throw new UnExceptedException(e, "Error occurred when reset heap arenas.");
        }
    }

    private void resetHeapArenas(XCacheMemoryLimiter limiter) throws ReflectiveOperationException {
        Field heapAreasField = this.getClass().getSuperclass().getDeclaredField("heapArenas");
        heapAreasField.setAccessible(true);
        Object[] heapArenas = (Object[])heapAreasField.get(this);
        ArrayList<XCacheHeapPoolArena> metrics = new ArrayList<XCacheHeapPoolArena>(heapArenas.length);
        for (int i = 0; i < heapArenas.length; ++i) {
            XCacheHeapPoolArena arena = XCacheHeapPoolArena.create(heapArenas[i], limiter);
            heapArenas[i] = arena;
            metrics.add(arena);
        }
        Field heapArenaMetricsField = this.getClass().getSuperclass().getDeclaredField("heapArenaMetrics");
        heapArenaMetricsField.setAccessible(true);
        heapArenaMetricsField.set(this, Collections.unmodifiableList(metrics));
    }

    public ByteBuf buffer() {
        return this.proxy();
    }

    public ByteBuf buffer(int initialCapacity) {
        return this.proxy(initialCapacity);
    }

    public ByteBuf buffer(int initialCapacity, int maxCapacity) {
        return this.proxy(initialCapacity, maxCapacity);
    }

    public ByteBuf ioBuffer() {
        return this.proxy();
    }

    public ByteBuf ioBuffer(int initialCapacity) {
        return this.proxy(initialCapacity);
    }

    public ByteBuf ioBuffer(int initialCapacity, int maxCapacity) {
        return this.proxy(initialCapacity, maxCapacity);
    }

    public ByteBuf directBuffer() {
        return this.proxy();
    }

    public ByteBuf directBuffer(int initialCapacity) {
        return this.proxy(initialCapacity);
    }

    public ByteBuf directBuffer(int initialCapacity, int maxCapacity) {
        return this.proxy(initialCapacity, maxCapacity);
    }

    public ByteBuf heapBuffer() {
        return this.proxy();
    }

    public ByteBuf heapBuffer(int initialCapacity) {
        return this.proxy(initialCapacity);
    }

    public ByteBuf heapBuffer(int initialCapacity, int maxCapacity) {
        return this.proxy(initialCapacity, maxCapacity);
    }

    private ByteBuf proxy() {
        return this.proxy(0, 256, Integer.MAX_VALUE);
    }

    private ByteBuf proxy(int initialCapacity) {
        return this.proxy(0, initialCapacity, Integer.MAX_VALUE);
    }

    private ByteBuf proxy(int initialCapacity, int maxCapacity) {
        return this.proxy(0, initialCapacity, maxCapacity);
    }

    private ByteBuf proxy(int times, int initialCapacity, int maxCapacity) {
        try {
            return this.doAllocateBuffer(initialCapacity, maxCapacity);
        }
        catch (OutOfMemoryError e) {
            int currentPercent;
            if (times == 0) {
                this.metrics.incrementOutOfMemoryCount();
            }
            if ((currentPercent = 100 - 25 * (times + 1)) < 20) {
                log.warn(String.format("Memory allocate failed after %s times", times + 1));
                throw e;
            }
            try {
                this.commandInvokers.newLongInvoker(new ResetMemoryCommand(currentPercent)).invokeSync();
                return this.proxy(times + 1, initialCapacity, maxCapacity);
            }
            catch (CommandInvokeException cie) {
                log.warn("Error occurred when reset memory: " + cie.getMessage(), (Throwable)cie);
                this.trimCurrentThreadCache();
                return this.doAllocateBuffer(initialCapacity, maxCapacity);
            }
        }
    }

    private ByteBuf doAllocateBuffer(int initialCapacity, int maxCapacity) {
        return super.heapBuffer(initialCapacity, maxCapacity);
    }

    @Override
    public long max() {
        return this.limiter.limit();
    }

    @Override
    public long used() {
        return this.limiter.used();
    }
}

