/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.mem;

import io.netty.buffer.XCacheMemoryLimiter;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.xcache.server.mem.AllocatorOutOfMemoryError;

public class DefaultXCacheMemoryLimiter
implements XCacheMemoryLimiter {
    private final long limit;
    private final AtomicLong used;

    public DefaultXCacheMemoryLimiter(long limit) {
        this.limit = limit;
        this.used = new AtomicLong(0L);
    }

    @Override
    public void incrementMemory(int capacity) {
        long newUsedMemory = this.used.addAndGet(capacity);
        if (newUsedMemory > this.limit) {
            this.used.addAndGet(-capacity);
            throw new AllocatorOutOfMemoryError("failed to allocate " + capacity + " byte(s) of memory (used: " + (newUsedMemory - (long)capacity) + ", max: " + this.limit + ')');
        }
    }

    @Override
    public long limit() {
        return this.limit;
    }

    @Override
    public long used() {
        return this.used.get();
    }

    @Override
    public void decrementMemory(int capacity) {
        this.used.addAndGet(-capacity);
    }
}

