/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.metric;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import kd.bos.xcache.server.metric.DefaultGaugeSet;
import kd.bos.xcache.server.metric.GaugeSet;

public class MetricsCenter {
    private final SortedMap<String, GaugeSet> gaugeSets = new TreeMap<String, GaugeSet>();
    private final MetricRegistry registry;
    private static volatile boolean init;
    private static volatile MetricsCenter me;

    public MetricsCenter(MetricRegistry registry) {
        this.registry = registry;
    }

    public static synchronized void reset() {
        if (me != null) {
            me.clear();
        }
        init = false;
    }

    public static synchronized void init(MetricRegistry registry) {
        if (init) {
            return;
        }
        me = new MetricsCenter(registry);
        init = true;
    }

    public static MetricsCenter get() {
        if (!init) {
            throw new IllegalStateException("Need init first");
        }
        return me;
    }

    public void register(GaugeSet gaugeSet) {
        String group = gaugeSet.group();
        for (Map.Entry<String, Gauge> each : gaugeSet.gauges().entrySet()) {
            this.register(group, each.getKey(), each.getValue());
        }
    }

    public synchronized void register(String group, String name, Gauge gauge) {
        GaugeSet set = this.gaugeSets.computeIfAbsent(group, DefaultGaugeSet::new);
        String registerName = String.format("%s%s.%s", "kd.metrics.xcache-server.", group, name);
        if (set.gauges().containsKey(name)) {
            this.registry.remove(registerName);
        }
        set.gauges().put(name, gauge);
        this.registry.register(registerName, (Metric)gauge);
    }

    public Gauge metric(String group, String name) {
        return this.gaugeSets.get(group) != null ? (Gauge)((GaugeSet)this.gaugeSets.get(group)).gauges().get(name) : null;
    }

    public GaugeSet metrics(String group) {
        return (GaugeSet)this.gaugeSets.get(group);
    }

    public SortedMap<String, GaugeSet> metrics() {
        return this.gaugeSets;
    }

    public MetricRegistry registry() {
        return this.registry;
    }

    public synchronized void clear() {
        this.registry.removeMatching((n, m) -> true);
        this.gaugeSets.clear();
    }
}

